﻿function login(username, password) {
    document.getElementById('password').value = password;
    document.getElementById('username').value = username;
    document.getElementById('loginSubmit').click();
}

function openFullscreen(id) {
    if (isFullscreen())
    {
        document.exitFullscreen();
    }
    else
    {
        document.getElementById(id).requestFullscreen();    
    }
}

function isFullscreen() {
    return document.fullscreenElement != null; 
}

function getDimensions() {
    return {
        width: window.innerWidth,
        height: window.innerHeight
    };
}

function downloadFileFromStream(fileName, contentStreamReference) {
    contentStreamReference.arrayBuffer().then(arrayBuffer => {
        const blob = new Blob([arrayBuffer]);
        const url = URL.createObjectURL(blob);
        const anchorElement = document.createElement('a');
        anchorElement.href = url;
        anchorElement.download = fileName ?? '';
        anchorElement.click();
        anchorElement.remove();
        URL.revokeObjectURL(url);
    });
}

function getBrowserTimeZone() {
    const options = Intl.DateTimeFormat().resolvedOptions();
    return options.timeZone;
}

function getBrowserLanguage() {
    return navigator.language;
}

async function readFromClipboard() {
    return await navigator.clipboard.readText();
}

function copyToClipboard(textToCopy) {
    // Navigator clipboard api needs a secure context (https)
    if (navigator.clipboard && window.isSecureContext) {
        navigator.clipboard.writeText(textToCopy).then(() => {
        });
    } else {
        // Use the 'out of viewport hidden text area' trick
        const textArea = document.createElement("textarea");
        textArea.value = textToCopy;

        // Move textarea out of the viewport so it's not visible
        textArea.style.position = "absolute";
        textArea.style.left = "-999999px";

        document.body.prepend(textArea);
        textArea.select();

        try {
            document.execCommand('copy');
        } catch (error) {
            console.error(error);
        } finally {
            textArea.remove();
        }
    }
}

function setIdleTimeout(timeout, dotnethelper) {
    var token = setTimeout(() => {
        dotnethelper.invokeMethodAsync("ShowIdleTimeout");
    }, timeout);
    
    document.onmousemove = resetTimeDelay;
    document.onkeypress = resetTimeDelay;

    function resetTimeDelay() {
        clearTimeout(token);
        token = setTimeout(() => {
            dotnethelper.invokeMethodAsync("ShowIdleTimeout");
        }, timeout);
    }
}