@{
    RootModule = 'Universal.psm1'
    ModuleVersion = '5.6.9'
    GUID = '8fd8507b-4df7-477f-854e-f31e8a0fa830'
    Author = 'Ironman Software'
    CompanyName = 'Ironman Software'
    Copyright = '(c) 2025 Ironman Software. All rights reserved.'
    Description = 'Module for PowerShell Universal.'
    RequiredAssemblies = @('UniversalDashboard.dll')
    NestedModules = @('UniversalDashboard.dll', 'Universal.Cmdlets.dll')

    AliasesToExport = @(
        'New-UDFormValidationResult',
        'New-UDDashboard',
        'New-PSUDashboard',
        "Start-PSUDashboard",
        "Stop-PSUDashboard",
        "Remove-PSUDashboard",
        "Get-PSUDashboard",
        "Remove-PSUServer",
        "Invoke-PSUCommand",
        "New-PSUBranding"
    )

    FunctionsToExport = @(
        'Install-PSUServer'
        'Resolve-Variable'
        'Start-PSUServer',
        'Update-PSUServer',
        'Uninstall-PSUServer'

    # Dashboard

        'Add-UDElement'
        'Clear-UDElement'
        'ConvertTo-UDCSSValue'
        'ConvertTo-UDThemeCss'
        'Find-Object'
        'Find-UDIcon'
        'Get-UDCacheData'
        'Get-UDElement'
        'Get-UDSessionData'
        'Get-UDTheme'
        'Get-UDThemeColors'
        'Hide-UDModal'
        'Hide-UDToast'
        'Hide-UDSnackbar'
        'Invoke-UDEvent'
        'Invoke-UDJavaScript'
        'Invoke-UDRedirect'
        'Invoke-UDForm'
        'Join-HashTable'
        'Measure-PSUBuiltInVariables'
        'Measure-PSUConvertToJsonDepth'
        'New-UDAlert'
        'New-UDAppBar'
        'New-UDAutocomplete'
        'New-UDAutocompleteOption'
        'New-UDAvatar'
        'New-UDAvatarGroup'
        'New-UDBackdrop'
        'New-UDBadge'
        'New-UDBarChartDataset'
        'New-UDBarChartOptions'
        'New-UDButton'
        'New-UDButtonGroup'
        'New-UDButtonGroupItem'
        'New-UDBreadcrumbs'
        'New-UDCard'
        'New-UDCardBody'
        'New-UDCardExpand'
        'New-UDCardFooter'
        'New-UDCardHeader'
        'New-UDCardMedia'
        'New-UDCategoryChartAxis'
        'New-UDChart'
        'New-UDChartDataset'
        'New-UDChartLayoutOptions'
        'New-UDChartLegendOptions'
        'New-UDChartOptions'
        'New-UDChartTitleOptions'
        'New-UDChartTooltipOptions'
        'New-UDCheckbox'
        'New-UDChip'
        'New-UDCodeEditor'
        'New-UDCollapsible'
        'New-UDCollapsibleItem'
        'New-UDCollection'
        'New-UDCollectionItem'
        'New-UDColumn'
        'New-UDContainer'
        'New-UDCounter'
        'New-UDApp'
        'New-UDDataGrid'
        'New-UDDataGridColumn'
        'New-UDDatePicker'
        'New-UDDateRangePicker'
        'New-UDDivider'
        'New-UDDoughnutChartDataset'
        'New-UDDoughnutChartOptions'
        'New-UDDrawer'
        'New-UDDynamic'
        'New-UDEditor'
        'New-UDError'
        'New-UDExpansionPanel'
        'New-UDExpansionPanelGroup'
        'New-UDFab'
        'New-UDFabButton'
        'New-UDFloatingActionButton'
        'New-UDFooter'
        'New-UDForm'
        'New-UDValidationResult'
        'New-UDGauge'
        'New-UDGrid'
        'New-UDGridLayout'
        'New-UDPageLayout'
        'New-UDItemLayout'
        'New-UDHeading'
        'New-UDHelmet'
        "New-UDHtml"
        'New-UDIcon'
        'New-UDIconButton'
        'New-UDIFrame'
        'New-UDImage'
        'New-UDImageCarousel'
        'New-UDImageCarouselItem'
        'New-UDInput'
        'New-UDInputAction'
        'New-UDInputField'
        'New-UDLayout'
        'New-UDLinearChartAxis'
        'New-UDLineChartDataset'
        'New-UDLineChartOptions'
        'New-UDLink'
        'New-UDList'
        'New-UDListItem'
        'New-UDLogarithmicChartAxis'
        'New-UDMarkdown'
        'New-UDMenu'
        'New-UDMenuItem'
        'New-UDMonitor'
        'New-UDNivoChart'
        'New-UDNivoChartAxisOptions'
        'New-UDNivoFill'
        'New-UDNivoPattern'
        'New-UDPaper'
        'New-UDParagraph'
        'New-UDPolarChartDataset'
        'New-UDPolarChartOptions'
        'New-UDPreloader'
        'New-UDProgress'
        'New-UDRadarChartDataset'
        'New-UDRadio'
        'New-UDRadioGroup'
        'New-UDRating'
        'New-UDRow'
        'New-UDSelect'
        'New-UDSelectGroup'
        'New-UDSelectOption'
        'New-UDSideNav'
        'New-UDSideNavItem'
        'New-UDSlider'
        'New-UDSkeleton'
        'New-UDSpan'
        'New-UDSpeedDial'
        'New-UDSpeedDialAction'
        'New-UDSplitPane'
        'New-UDStack'
        'New-UDStep'
        'New-UDStepper'
        'New-UDStyle'
        'New-UDSwitch'
        'New-UDSyntaxHighlighter'
        'New-UDTab'
        'New-UDTable'
        'New-UDTableColumn'
        'New-UDTableTextOption'
        'New-UDTabs'
        'New-UDTextbox'
        'New-UDTheme'
        'New-UDTimeline'
        'New-UDTimelineItem'
        'New-UDTimePicker'
        'New-UDToggleButton'
        'New-UDToggleButtonGroup'
        'New-UDTooltip'
        'New-UDTransferList'
        'New-UDTransferListItem'
        'New-UDTreeNode'
        'New-UDTreeView'
        'New-UDTypography'
        'Out-UDChartData'
        'Out-UDDataGridData'
        'Out-UDDataGridExport'
        'Out-UDGridData'
        'Out-UDMonitorData'
        'Out-UDTableData'
        'Protect-UDSection'
        'Remove-UDElement'
        'Reset-UDTheme'
        'Select-UDElement'
        'Set-UDCacheData'
        'Set-UDClipboard'
        'Set-UDElement'
        'Set-UDLanguage'
        'Set-UDSessionData'
        'Set-UDTheme'
        'Show-UDConfirm'
        'Show-UDModal'
        'Show-UDSnackbar'
        'Show-UDToast'
        'Start-UDDownload'
        'Sync-UDElement'
        'Update-UDDashboard'
        'Write-UDLog'
        'Test-UDForm'
        'Test-UDConnected'
        'New-UDUpload'
        'Start-UDDashboard',
        'New-UDDateTime'
        'New-UDErrorBoundary'
        'Debug-PSUDashboard'
        'New-UDTransition'
        'New-UDHidden'

        'New-UDMapBaseLayer'
        'New-UDMapFeatureGroup'
        'ConvertFrom-GeoJson'
        'New-UDMapIcon'
        'New-UDMapLayerControl'
        'New-UDMap'
        'New-UDMapMarker'
        'New-UDMapOverlay'
        'New-UDMapPopup'
        'New-UDMapRasterLayer'
        'New-UDMapVectorLayer'

        'New-UDSparkline'
        'New-UDNivoTheme'
        'New-UDChartJSDataset'
        'New-UDChartJS'
        'New-UDChartJSMonitor'
        'Out-UDChartJSMonitorData'
    )
    CmdletsToExport = @(
        'Add-PSUComputerTag'
        'Clear-PSUDeployment'
        'Get-PSUDeployment'
        'New-PSUDeployment'
        'Remove-PSUDeployment'
        'Select-PSUDeployment'
        'Publish-PSUDeployment'

        'ConvertTo-UDObject'
        'Disconnect-PSUServer'
        'New-PSUApp'
        'New-UDPage'
        'Remove-PSUCache'
        'Remove-PSUComputerTag'
        'ConvertTo-JsonEx'
        'Get-PSUDashboardEndpointRunspace'
        'Connect-PSUServer'
        'ConvertTo-JsonEx'
        'Clear-PSUCache'
        'Get-PSUComputerGroup'
        'Get-PSUEndpoint'
        'Get-PSUEndpointDocumentation'
        'Get-PSUAppToken'
        'Get-PSUComputer'
        'Get-PSUEventHub'
        'Get-PSUEventHubConnection'
        'Get-PSEnvironment'
        'Get-PSUFolder'
        'Get-PSUGitStatus'
        'Get-PSUGitSetting'
        'Get-PSUIdentity'
        'Get-PSUInformation'
        'Get-PSuJob'
        'Get-PSUJobFeedback'
        'Get-PSUJobOutput'
        'Get-PSUJobParameter'
        'Get-PSUJobPipelineOutput'
        'Get-PSULicense'
        'Get-PSUPublishedFolder'
        'Get-PSURole'
        'Get-PSUSchedule'
        'Get-PSUScript'
        'Get-PSUSetting'
        'Get-PSUStats'
        'Get-PSUSystemEvent'
        'Get-PSUTag'
        'Get-PSUVariable'
        'Get-PSUTerminal'
        'Get-PSUApp'
        'Get-PSUTerminalInstance'
        'Get-UDPage'
        'Grant-PSUAppToken'
        'Invoke-PSUEndpoint'
        'Invoke-PSUScript'
        'Invoke-UDEndpoint'
        'Invoke-PSUTerminalCommand'
        'Import-PSUTemplate'
        'Import-PSUSecret'
        'New-PSUApiResponse'
        'New-PSUAuthenticationResult'
        'New-PSUAuthorizationClaim'
        'New-PSUComputerGroup'
        'New-PSUGitSetting'
        'New-PSUEnvironment'
        'Get-PSUEnvironment'
        'New-PSUEndpoint'
        'New-PSUEndpointDocumentation'
        'New-PSUHotkey'
        'New-PSURole'
        'New-PSUPortalComponent'
        'New-PSUPortalPage'
        'New-PSUScript'
        'New-PSUSystemEvent'
        'New-PSUTerminal'
        'Start-PSUTerminalInstance'
        'Stop-PSUTerminalInstance'
        'New-PSUFolder'
        'New-PSUHealthCheck'
        'New-PSUHealthCheckResult'
        'New-PSUIdentity'
        'New-PSUProtocolHandler'
        'New-PSUEnvironment'
        'New-PSUFileAssociation'
        'New-PSULoggingTarget'
        'New-PSUMiddleware'
        'New-PSUSchedule'
        'New-PSUTag'
        'New-PSUVariable'
        'New-UDElement'
        'New-UDEndpoint'
        'New-UDEndpointSchedule'
        'New-PSUPublishedFolder'
        'New-PSURateLimit'
        'New-PSUTranslation'
        'New-PSUValidationResult'
        'New-PSUEventHub'
        'Measure-PSUBlock'
        'Merge-PSUGitEdit'
        'Out-PSUPipeline'
        'Publish-PSUStaticApp'
        'Remove-PSUApp'
        'Remove-PSUEndpoint'
        'Remove-PSUEndpointDocumentation'
        'Remove-PSUJobPipelineOutput'
        'Remove-PSUIdentity'
        'Remove-PSUEnvironment'
        'Remove-PSUSchedule'
        'Remove-PSUScript'
        'Remove-PSULicense'
        'Remove-PSUTag'
        'Remove-PSURole'
        'Remove-PSUVariable'
        'Remove-UDEndpoint'
        'Remove-PSUSystemEvent'
        'Rename-PSUScript'
        'Revoke-PSUAppToken'
        'Send-PSUEvent'
        'Set-PSUAuthenticationMethod'
        'Set-PSUBranding'
        'Set-PSUComputer'
        'Set-PSUComputerGroup'
        'Set-PSUEndpoint'
        'Set-PSUGitSetting'
        'Set-PSUIdentity'
        'Set-PSUJobFeedback'
        'Set-PSULicense'
        'Set-PSUEnvironment'
        'Set-PSUScript'
        'Set-PSUSchedule'
        'Set-PSUSetting'
        'Set-PSUTag'
        'Set-PSUVariable'
        'Start-PSUApp'
        'Start-PSUGitEdit'
        'Stop-PSUGitEdit'
        'Stop-PSUJob'
        'Stop-PSUApp'
        'Sync-PSUComponent'
        'Sync-PSUConfiguration'
        'Sync-PSUGit'
        'Test-PSUAppToken'
        'Wait-PSUJob'
        'Wait-PSUDashboardEndpoint'
        'Write-PSUError'
        'New-PSUTrigger'
        'Set-PSUTrigger'
        'Get-PSUTrigger'
        'Remove-PSUGitSetting'
        'Remove-PSUTrigger'
        'Remove-PSUComputerGroup'
        'New-PSULoginPage'
        'Set-PSUCache'
        'Get-PSUCache'
        'New-PSULoginPageLink'
        'Write-PSULog'
    )

    VariablesToExport = ''
    # DSC resources to export from this module
    # DscResourcesToExport = @()

    # List of all modules packaged with this module
    # ModuleList = @()

    # List of all files packaged with this module
    # FileList = @()

    # Private data to pass to the module specified in RootModule/ModuleToProcess. This may also contain a PSData hashtable with additional module metadata used by PowerShell.
    PrivateData = @{

        PSData = @{

        # Tags applied to this module. These help with module discovery in online galleries.
            Tags = @('universal', 'universal-dashboard', 'universal-automation')

            # A URL to the license for this module.
            LicenseUri = 'https://ironmansoftware.com/legal/'

            # A URL to the main website for this project.
            ProjectUri = 'https://ironmansoftware.com/powershell-universal'

            # A URL to an icon representing this module.
            IconUri = 'https://imsreleases.blob.core.windows.net/universal/logo.png'

            # ReleaseNotes of this module
            ReleaseNotes = 'https://docs.powershelluniversal.com/changelog'

            # Prerelease   = "beta2"

        } # End of PSData hashtable

    } # End of PrivateData hashtable

    # HelpInfo URI of this module
    # HelpInfoURI = ''

    # Default prefix for commands exported from this module. Override the default prefix using Import-Module -Prefix.
    # DefaultCommandPrefix = ''

}
