New-UDPage -Name 'Scopes' -Icon (New-UDIcon -Icon 'UserGear') -Content {

    New-UDComponentDemo -Title 'Cache' -Description 'Cache scope stores data for all users. It does not expire automatically, so use it wisely' -Content {

        New-UDStack -Direction 'column' -Content {
            if ($Cache:Demo) {
                New-UDTypography "Cache value: $Cache:Demo"
            }
            New-UDForm -Content {
                New-UDTextbox -Id 'cacheValue'
            } -OnSubmit {
                $Cache:Demo = $EventData.cacheValue 
                New-UDTypography "Value has been stored in the cache. Reload page to see value."
                New-UDButton -Text 'Reload Page' -OnClick {
                    Invoke-UDJavaScript -JavaScript 'window.location.reload()'
                }
            }

        }
    }

    New-UDComponentDemo -Title 'Page' -Description 'Page scope stores data for the current page (e.g. tab). The data won''t be available across tabs and will be removed once the tab is closed.' -Content {
        New-UDStack -Direction 'column' -Content {
            New-UDForm -Content {
                New-UDTextbox -Id 'cacheValue'
            } -OnSubmit {
                $Page:Demo = $EventData.cacheValue 
                New-UDTypography "Value has been stored in the page scope."

            }

            New-UDButton -Text 'Show Page Data' -OnClick {
                Show-UDToast $Page:Demo
            }
        }
    }

    New-UDComponentDemo -Title 'Session' -Description 'Session scope stores data with the current user''s session. If you reload the page, the data will still be stored. If you open a new tab, the same data is available.' -Content {

        New-UDStack -Direction 'column' -Content {
            New-UDDynamic -Content {
                if ($Session:Demo) {
                
                    New-UDTypography "Session value: $Session:Demo"
                }
            }
            New-UDForm -Content {
                New-UDTextbox -Id 'cacheValue'
            } -OnSubmit {
                $Session:Demo = $EventData.cacheValue 
                New-UDTypography "Value has been stored in the session. Reload page to see value."
                New-UDButton -Text 'Reload Page' -OnClick {
                    Invoke-UDJavaScript -JavaScript 'window.location.reload()'
                }
            }
        }
    }

} 