New-UDPage -Name 'About' -Content {
    New-UDCard -Body (New-UDCardBody -Content {
            New-UDAlert -Text 'PowerShell Universal Apps are highly customizable webpages built with PowerShell.' -Severity info
        }) -Header (New-UDCardHeader -Title "PowerShell Universal Apps" -Avatar (New-UDImage -Url "$($PSUBasePath)/assets/logo.png" -Height 50 -Width 50))

    New-UDCard -Title "PowerShell" -Content {
        New-UDStack -Content {
            New-UDTypography -Variant headline -Text "Build your entire website with PowerShell. Integrate with any PowerShell module and dynamically generate pages." -Sx @{
                marginBottom = "10px"
            }
            New-UDSyntaxHighlighter -Language powershell -Code @"
    New-UDCard -Title "Build with PowerShell" -Content {
        New-UDStack -Content {
            New-UDTypography -Variant headline -Text `"Build your entire website with PowerShell. Integrate with any PowerShell module and dynamically generate pages.`" -Sx @{
                marginBottom = `"10px`"
            }
            New-UDSyntaxHighlighter -Language powershell -Code @`"
            `"@
        } -Direction column
    }
"@
        } -Direction column
    }
    New-UDLayout -Columns 2 -Content {
        New-UDCard -Title "Components" -Content {
            New-UDStack -Content {
                New-UDTypography -Variant headline -Text "50+ components including everything from alerts to textboxes. View all the components by navigating this website." -Sx @{
                    marginBottom = "10px"
                }
                New-UDAlert -Text "Hundreds of parameters to fully customize each component."
            } -Direction column
        }
        New-UDCard -Title "Interactive" -Content {
            New-UDStack -Content {
                New-UDTypography -Variant headline -Text "Interactive buttons, forms and other input controls." -Sx @{
                    marginBottom = "10px"
                }
                New-UDStack -Content {
                    New-UDTextbox -Id 'name' -Placeholder "Name"
                    New-UDButton -Text "Click Me" -OnClick {
                        $Name = Get-UDElement -Id 'name' -Property 'value'
                        if ($Name -eq $null) {
                            $Name = "you"
                        }
                        Show-UDToast "Hello, $Name!"
                    } -Icon (New-UDIcon -Icon User)
                }
                New-UDSlider -Marks -Minimum 1 -Maximum 100 -OnChange {
                    Show-UDToast "$EventData"
                }
            } -Direction column
        }
        New-UDCard -Title "Styling" -Content {
            New-UDStack -Content {
                New-UDTypography -Variant headline -Text "Customize each component and build themes that match your organization's branding." -Sx @{
                    marginBottom = "10px"
                }
                New-UDButton -Text "Styled Button" -Style @{
                    borderRadius = "3px"
                    border       = "3px #8f6cf7 solid"
                    background   = "#6337e8"
                }
            } -Direction column
        }
        New-UDCard -Title "Layout" -Content {
            New-UDStack -Content {
                New-UDTypography -Variant headline -Text "Adaptive layouts that adjust to screen sizes. Try resizing the window." -Sx @{
                    marginBottom = "10px"
                }
                New-UDRow -Columns {
                    New-UDColumn -SmallSize 12 -MediumSize 6 -LargeSize 1 -Content {
                        New-UDAvatar -Children { "A" }
                    }
                    New-UDColumn -SmallSize 12 -MediumSize 6 -LargeSize 1 -Content {
                        New-UDAvatar -Children { "B" }
                    }
                    New-UDColumn -SmallSize 12 -MediumSize 6 -LargeSize 1 -Content {
                        New-UDAvatar -Children { "C" }
                    }
                    New-UDColumn -SmallSize 12 -MediumSize 6 -LargeSize 1 -Content {
                        New-UDAvatar -Children { "D" }
                    }
                }
            } -Direction column
        }
        New-UDCard -Title "Security" -Content {
            New-UDStack -Content {
                New-UDTypography -Variant headline -Text "Leverage authentication and authorization to customize your site." -Sx @{
                    marginBottom = "10px"
                }
                New-UDStack -Content {
                    New-UDChip -Label $User -Color success
                    $Roles | Select-Object -First 5 | ForEach-Object {
                        New-UDChip -Label $_ -Color secondary
                    }
                } -Spacing 2
                New-UDButton -Text 'Admin Console' -OnClick {
                    Invoke-UDRedirect -Url '/admin' -OpenInNewWindow -Native
                } -Icon (New-UDIcon -Icon Cog)
            } -Direction column
        }
        New-UDCard -Title "Visualize" -Content {
            New-UDStack -Content {
                New-UDTypography -Variant headline -Text "Visualize your data with components like tables and charts." -Sx @{
                    marginBottom = "10px"
                }

                New-UDStack -Content {
                    New-UDDynamic -Content {
                        $Data = 1..10 | ForEach-Object {
                            [PSCustomObject]@{ Name = "Item $_"; value = Get-Random -Minimum 1 -Maximum 100 }
                        }
                        New-UDChartJS -Type 'bar' -Data $Data -DataProperty Value -Id 'test' -LabelProperty Name -BackgroundColor '#274916' -BorderColor '#162312' -Options @{
                            responsive = $false
                            plugins    = @{
                                legend = @{
                                    display = $false
                                }
                            }
                        }
                    } -AutoRefreshInterval 5 -AutoRefresh

                    New-UDDynamic -Content {
                        $Data = 1..10 | ForEach-Object {
                            [PSCustomObject]@{ Name = "Item $_"; value = Get-Random -Minimum 1 -Maximum 100 }
                        }
                        New-UDChartJS -Type 'pie' -Data $Data -DataProperty Value -Id 'test2' -LabelProperty Name -BackgroundColor '#111b26' -BorderColor '#153450' -Options @{
                            responsive = $false
                            plugins    = @{
                                legend = @{
                                    display = $false
                                }
                            }

                        }
                    } -AutoRefreshInterval 5 -AutoRefresh

                
                    New-UDDynamic -Content {
                        $Data = 1..10 | ForEach-Object {
                            [PSCustomObject]@{ Name = "Item $_"; value = Get-Random -Minimum 1 -Maximum 100 }
                        }
                        New-UDChartJS -Type 'radar' -Data $Data -DataProperty Value -Id 'test3' -LabelProperty Name -BackgroundColor '#111b26' -BorderColor '#153450' -Options @{
                            responsive = $false
                            plugins    = @{
                                legend = @{
                                    display = $false
                                }
                            }
                            scales     = @{
                                r = @{
                                    ticks = @{
                                        display = $false
                                    }
                                }
                            }
                        }
                    } -AutoRefreshInterval 5 -AutoRefresh
                }
            } -Direction column
        }
    }
}