﻿IF OBJECT_ID(N'[__EFMigrationsHistory]') IS NULL
BEGIN
    CREATE TABLE [__EFMigrationsHistory] (
        [MigrationId] nvarchar(150) NOT NULL,
        [ProductVersion] nvarchar(32) NOT NULL,
        CONSTRAINT [PK___EFMigrationsHistory] PRIMARY KEY ([MigrationId])
    );
END;
GO

BEGIN TRANSACTION;
IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [Computer] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        CONSTRAINT [PK_Computer] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [DbVersion] (
        [Id] bigint NOT NULL IDENTITY,
        [DatabaseVersion] int NOT NULL,
        [UpgradeDate] datetime2 NOT NULL,
        CONSTRAINT [PK_DbVersion] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [GitStatus] (
        [Id] bigint NOT NULL IDENTITY,
        [CommitId] nvarchar(max) NULL,
        [Timestamp] datetime2 NOT NULL,
        [SyncTime] time NOT NULL,
        [Changes] int NOT NULL,
        [Location] nvarchar(max) NULL,
        [Remote] nvarchar(max) NULL,
        [Result] int NOT NULL,
        [ResultMessage] nvarchar(max) NULL,
        CONSTRAINT [PK_GitStatus] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [Identity] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Source] int NOT NULL,
        [RoleName] nvarchar(max) NULL,
        CONSTRAINT [PK_Identity] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [JobLog] (
        [Id] bigint NOT NULL,
        [Log] nvarchar(max) NULL
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [Upload] (
        [Id] bigint NOT NULL IDENTITY,
        [UploadId] nvarchar(max) NULL,
        [Name] nvarchar(max) NULL,
        [FileName] nvarchar(max) NULL,
        [TimeStamp] datetime2 NOT NULL,
        [ContentType] nvarchar(max) NULL,
        CONSTRAINT [PK_Upload] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [Variable] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Value] nvarchar(max) NULL,
        [UserName] nvarchar(max) NULL,
        [Password] nvarchar(max) NULL,
        [Secret] bit NOT NULL,
        [Vault] nvarchar(max) NULL,
        [Type] nvarchar(max) NULL,
        [CreatedTime] datetime2 NOT NULL,
        [UpdatedTime] datetime2 NOT NULL,
        [Description] nvarchar(max) NULL,
        [MissingSecret] bit NOT NULL,
        [DisableRunAsSupport] bit NOT NULL,
        CONSTRAINT [PK_Variable] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [AppToken] (
        [Id] bigint NOT NULL IDENTITY,
        [Token] nvarchar(max) NULL,
        [IdentityId] bigint NOT NULL,
        [Revoked] bit NOT NULL,
        [Role] nvarchar(max) NULL,
        [Created] datetime2 NOT NULL,
        [Expiration] datetime2 NOT NULL,
        [RevokedDate] datetime2 NOT NULL,
        [CreatedById] bigint NULL,
        CONSTRAINT [PK_AppToken] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_AppToken_Identity_CreatedById] FOREIGN KEY ([CreatedById]) REFERENCES [Identity] ([Id]) ON DELETE NO ACTION,
        CONSTRAINT [FK_AppToken_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id]) ON DELETE CASCADE
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [TerminalInstance] (
        [Id] bigint NOT NULL IDENTITY,
        [Terminal] nvarchar(max) NULL,
        [ProcessId] int NOT NULL,
        [IdentityId] bigint NULL,
        [Status] int NOT NULL,
        [IdleTime] datetime2 NOT NULL,
        [StartTime] datetime2 NOT NULL,
        [Port] int NOT NULL,
        CONSTRAINT [PK_TerminalInstance] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_TerminalInstance_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id]) ON DELETE NO ACTION
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [Job] (
        [Id] bigint NOT NULL IDENTITY,
        [CreatedTime] datetime2 NOT NULL,
        [StartTime] datetime2 NOT NULL,
        [EndTime] datetime2 NOT NULL,
        [Status] int NOT NULL,
        [Output] nvarchar(max) NULL,
        [IsScriptDeleted] bit NOT NULL,
        [ScriptFullPath] nvarchar(max) NULL,
        [ScriptCommitId] nvarchar(max) NULL,
        [AppTokenId] bigint NULL,
        [IdentityId] bigint NOT NULL,
        [ParentJobId] bigint NULL,
        [ParentLineNumber] int NOT NULL,
        [Debug] bit NOT NULL,
        [ComputerName] nvarchar(max) NULL,
        [Port] int NOT NULL,
        [ProcessId] int NOT NULL,
        [RunspaceId] int NOT NULL,
        [Activity] nvarchar(max) NULL,
        [CurrentOperation] nvarchar(max) NULL,
        [PercentComplete] int NOT NULL,
        [SecondsRemaining] int NOT NULL,
        [StatusDescription] nvarchar(max) NULL,
        [Environment] nvarchar(max) NULL,
        [AgentId] bigint NULL,
        [ComputerId] bigint NOT NULL,
        [ErrorAction] int NOT NULL,
        [Notes] nvarchar(max) NULL,
        [Credential] nvarchar(max) NULL,
        [ScheduleId] bigint NOT NULL,
        [Triggered] bit NOT NULL,
        [Trigger] nvarchar(max) NULL,
        [AccessToken] nvarchar(max) NULL,
        [IdToken] nvarchar(max) NULL,
        [RetryCount] int NOT NULL,
        CONSTRAINT [PK_Job] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_Job_AppToken_AppTokenId] FOREIGN KEY ([AppTokenId]) REFERENCES [AppToken] ([Id]) ON DELETE NO ACTION,
        CONSTRAINT [FK_Job_Computer_AgentId] FOREIGN KEY ([AgentId]) REFERENCES [Computer] ([Id]) ON DELETE NO ACTION,
        CONSTRAINT [FK_Job_Computer_ComputerId] FOREIGN KEY ([ComputerId]) REFERENCES [Computer] ([Id]) ON DELETE CASCADE,
        CONSTRAINT [FK_Job_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id]) ON DELETE CASCADE,
        CONSTRAINT [FK_Job_Job_ParentJobId] FOREIGN KEY ([ParentJobId]) REFERENCES [Job] ([Id]) ON DELETE NO ACTION
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [JobFeedback] (
        [Id] bigint NOT NULL IDENTITY,
        [Data] nvarchar(max) NULL,
        [Message] nvarchar(max) NULL,
        [Complete] bit NOT NULL,
        [IdentityId] bigint NULL,
        [JobId] bigint NULL,
        CONSTRAINT [PK_JobFeedback] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_JobFeedback_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id]) ON DELETE NO ACTION,
        CONSTRAINT [FK_JobFeedback_Job_JobId] FOREIGN KEY ([JobId]) REFERENCES [Job] ([Id]) ON DELETE NO ACTION
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [JobOutput] (
        [Id] bigint NOT NULL IDENTITY,
        [Message] nvarchar(max) NULL,
        [Type] int NOT NULL,
        [Data] nvarchar(max) NULL,
        [JobId] bigint NULL,
        [Timestamp] datetime2 NOT NULL,
        CONSTRAINT [PK_JobOutput] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_JobOutput_Job_JobId] FOREIGN KEY ([JobId]) REFERENCES [Job] ([Id]) ON DELETE NO ACTION
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [JobParameter] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [DisplayName] nvarchar(max) NULL,
        [Type] nvarchar(max) NULL,
        [JobId] bigint NULL,
        [Value] nvarchar(max) NULL,
        [VariableId] bigint NULL,
        [IsVariable] bit NOT NULL,
        [DisplayType] int NOT NULL,
        CONSTRAINT [PK_JobParameter] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_JobParameter_Job_JobId] FOREIGN KEY ([JobId]) REFERENCES [Job] ([Id]) ON DELETE NO ACTION,
        CONSTRAINT [FK_JobParameter_Variable_VariableId] FOREIGN KEY ([VariableId]) REFERENCES [Variable] ([Id]) ON DELETE NO ACTION
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [JobPipelineOutput] (
        [Id] bigint NOT NULL,
        [Data] nvarchar(max) NULL,
        [JsonData] nvarchar(max) NULL,
        [JobId] bigint NULL,
        CONSTRAINT [FK_JobPipelineOutput_Job_JobId] FOREIGN KEY ([JobId]) REFERENCES [Job] ([Id]) ON DELETE NO ACTION
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE TABLE [Notification] (
        [Id] bigint NOT NULL IDENTITY,
        [Title] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [CreatedTime] datetime2 NOT NULL,
        [CreatedBy] nvarchar(max) NULL,
        [JobId] bigint NULL,
        [IdentityId] bigint NOT NULL,
        CONSTRAINT [PK_Notification] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_Notification_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id]) ON DELETE CASCADE,
        CONSTRAINT [FK_Notification_Job_JobId] FOREIGN KEY ([JobId]) REFERENCES [Job] ([Id]) ON DELETE NO ACTION
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_AppToken_CreatedById] ON [AppToken] ([CreatedById]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_AppToken_IdentityId] ON [AppToken] ([IdentityId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_Job_AgentId] ON [Job] ([AgentId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_Job_AppTokenId] ON [Job] ([AppTokenId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_Job_ComputerId] ON [Job] ([ComputerId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_Job_IdentityId] ON [Job] ([IdentityId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_Job_ParentJobId] ON [Job] ([ParentJobId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_JobFeedback_IdentityId] ON [JobFeedback] ([IdentityId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_JobFeedback_JobId] ON [JobFeedback] ([JobId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_JobOutput_JobId] ON [JobOutput] ([JobId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_JobParameter_JobId] ON [JobParameter] ([JobId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_JobParameter_VariableId] ON [JobParameter] ([VariableId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_JobPipelineOutput_JobId] ON [JobPipelineOutput] ([JobId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_Notification_IdentityId] ON [Notification] ([IdentityId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_Notification_JobId] ON [Notification] ([JobId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    CREATE INDEX [IX_TerminalInstance_IdentityId] ON [TerminalInstance] ([IdentityId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220201023444_Init'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220201023444_Init', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220412195308_tag'
)
BEGIN
    ALTER TABLE [Job] ADD [MemoryBytes] bigint NOT NULL DEFAULT CAST(0 AS bigint);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220412195308_tag'
)
BEGIN
    ALTER TABLE [Job] ADD [Tags] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220412195308_tag'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220412195308_tag', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220505183416_TokenDescription'
)
BEGIN
    ALTER TABLE [AppToken] ADD [Description] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220505183416_TokenDescription'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220505183416_TokenDescription', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220529200901_Protect'
)
BEGIN
    CREATE TABLE [ProtectEvents] (
        [Id] bigint NOT NULL IDENTITY,
        [ComputerName] nvarchar(max) NULL,
        [Rule] nvarchar(max) NULL,
        [Timestamp] datetime2 NOT NULL,
        CONSTRAINT [PK_ProtectEvents] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220529200901_Protect'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220529200901_Protect', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220606180251_NotificationLevel'
)
BEGIN
    ALTER TABLE [ProtectEvents] ADD [Administrator] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220606180251_NotificationLevel'
)
BEGIN
    ALTER TABLE [ProtectEvents] ADD [ApplicationName] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220606180251_NotificationLevel'
)
BEGIN
    ALTER TABLE [ProtectEvents] ADD [ContentPath] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220606180251_NotificationLevel'
)
BEGIN
    ALTER TABLE [ProtectEvents] ADD [DomainName] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220606180251_NotificationLevel'
)
BEGIN
    ALTER TABLE [ProtectEvents] ADD [Script] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220606180251_NotificationLevel'
)
BEGIN
    ALTER TABLE [ProtectEvents] ADD [UserName] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220606180251_NotificationLevel'
)
BEGIN
    ALTER TABLE [Notification] ADD [Level] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220606180251_NotificationLevel'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220606180251_NotificationLevel', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220616161717_Activations'
)
BEGIN
    CREATE TABLE [Activations] (
        [Id] bigint NOT NULL IDENTITY,
        [ActivationLicense] nvarchar(max) NULL,
        [License] nvarchar(max) NULL,
        CONSTRAINT [PK_Activations] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220616161717_Activations'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220616161717_Activations', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220622125648_Computers'
)
BEGIN
    ALTER TABLE [Computer] ADD [HeartBeat] datetime2 NOT NULL DEFAULT '0001-01-01T00:00:00.0000000';
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220622125648_Computers'
)
BEGIN
    ALTER TABLE [Computer] ADD [Status] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220622125648_Computers'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220622125648_Computers', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220704105852_GitSettings'
)
BEGIN
    ALTER TABLE [Variable] ADD [DeleteSecret] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220704105852_GitSettings'
)
BEGIN
    CREATE TABLE [GitSettings] (
        [Id] bigint NOT NULL IDENTITY,
        [Remote] nvarchar(max) NULL,
        [Branch] nvarchar(max) NULL,
        [SyncBehavior] int NOT NULL,
        [InitBehavior] int NOT NULL,
        [UserName] nvarchar(max) NULL,
        [Password] nvarchar(max) NULL,
        [Interval] int NOT NULL,
        CONSTRAINT [PK_GitSettings] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220704105852_GitSettings'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220704105852_GitSettings', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220704132553_GrpcPort'
)
BEGIN
    ALTER TABLE [Computer] ADD [GrpcPort] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220704132553_GrpcPort'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220704132553_GrpcPort', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220704142607_TerminalHistory'
)
BEGIN
    CREATE TABLE [TerminalHistory] (
        [Id] bigint NOT NULL IDENTITY,
        [Input] nvarchar(max) NULL,
        [Output] nvarchar(max) NULL,
        [Timestamp] datetime2 NOT NULL,
        [ExecutionTime] time NOT NULL,
        [TerminalInstanceId] bigint NULL,
        CONSTRAINT [PK_TerminalHistory] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_TerminalHistory_TerminalInstance_TerminalInstanceId] FOREIGN KEY ([TerminalInstanceId]) REFERENCES [TerminalInstance] ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220704142607_TerminalHistory'
)
BEGIN
    CREATE INDEX [IX_TerminalHistory_TerminalInstanceId] ON [TerminalHistory] ([TerminalInstanceId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220704142607_TerminalHistory'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220704142607_TerminalHistory', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220714160753_ForeignKeyFix'
)
BEGIN
    ALTER TABLE [Job] DROP CONSTRAINT [FK_Job_Computer_ComputerId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220714160753_ForeignKeyFix'
)
BEGIN
    ALTER TABLE [Notification] DROP CONSTRAINT [FK_Notification_Identity_IdentityId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220714160753_ForeignKeyFix'
)
BEGIN
    DECLARE @var sysname;
    SELECT @var = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Notification]') AND [c].[name] = N'IdentityId');
    IF @var IS NOT NULL EXEC(N'ALTER TABLE [Notification] DROP CONSTRAINT [' + @var + '];');
    ALTER TABLE [Notification] ALTER COLUMN [IdentityId] bigint NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220714160753_ForeignKeyFix'
)
BEGIN
    ALTER TABLE [Job] ADD CONSTRAINT [FK_Job_Computer_ComputerId] FOREIGN KEY ([ComputerId]) REFERENCES [Computer] ([Id]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220714160753_ForeignKeyFix'
)
BEGIN
    ALTER TABLE [Notification] ADD CONSTRAINT [FK_Notification_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220714160753_ForeignKeyFix'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220714160753_ForeignKeyFix', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220808145137_GitStatusComputerName'
)
BEGIN
    ALTER TABLE [GitStatus] ADD [ComputerName] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220808145137_GitStatusComputerName'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220808145137_GitStatusComputerName', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220808171129_JobIndicies'
)
BEGIN
    DECLARE @var1 sysname;
    SELECT @var1 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Job]') AND [c].[name] = N'Tags');
    IF @var1 IS NOT NULL EXEC(N'ALTER TABLE [Job] DROP CONSTRAINT [' + @var1 + '];');
    ALTER TABLE [Job] ALTER COLUMN [Tags] nvarchar(450) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220808171129_JobIndicies'
)
BEGIN
    DECLARE @var2 sysname;
    SELECT @var2 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Job]') AND [c].[name] = N'ScriptFullPath');
    IF @var2 IS NOT NULL EXEC(N'ALTER TABLE [Job] DROP CONSTRAINT [' + @var2 + '];');
    ALTER TABLE [Job] ALTER COLUMN [ScriptFullPath] nvarchar(450) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220808171129_JobIndicies'
)
BEGIN
    CREATE INDEX [IX_Job_ScriptFullPath] ON [Job] ([ScriptFullPath]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220808171129_JobIndicies'
)
BEGIN
    CREATE INDEX [IX_Job_Tags] ON [Job] ([Tags]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220808171129_JobIndicies'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220808171129_JobIndicies', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220822150155_Files'
)
BEGIN
    ALTER TABLE [JobPipelineOutput] ADD [FileId] bigint NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220822150155_Files'
)
BEGIN
    ALTER TABLE [JobParameter] ADD [FileId] bigint NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220822150155_Files'
)
BEGIN
    CREATE TABLE [Files] (
        [Id] bigint NOT NULL IDENTITY,
        [FileName] nvarchar(max) NULL,
        [Content] varbinary(max) NULL,
        CONSTRAINT [PK_Files] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220822150155_Files'
)
BEGIN
    EXEC(N'CREATE UNIQUE INDEX [IX_JobPipelineOutput_FileId] ON [JobPipelineOutput] ([FileId]) WHERE [FileId] IS NOT NULL');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220822150155_Files'
)
BEGIN
    EXEC(N'CREATE UNIQUE INDEX [IX_JobParameter_FileId] ON [JobParameter] ([FileId]) WHERE [FileId] IS NOT NULL');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220822150155_Files'
)
BEGIN
    ALTER TABLE [JobParameter] ADD CONSTRAINT [FK_JobParameter_Files_FileId] FOREIGN KEY ([FileId]) REFERENCES [Files] ([Id]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220822150155_Files'
)
BEGIN
    ALTER TABLE [JobPipelineOutput] ADD CONSTRAINT [FK_JobPipelineOutput_Files_FileId] FOREIGN KEY ([FileId]) REFERENCES [Files] ([Id]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220822150155_Files'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220822150155_Files', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220830145200_LoadingInfo'
)
BEGIN
    ALTER TABLE [Computer] ADD [LoadingInfo] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220830145200_LoadingInfo'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220830145200_LoadingInfo', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220912132343_ExternalGit'
)
BEGIN
    ALTER TABLE [GitSettings] ADD [ExternalGit] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220912132343_ExternalGit'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220912132343_ExternalGit', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220917172915_GitManualMode'
)
BEGIN
    ALTER TABLE [GitSettings] ADD [ManualMode] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220917172915_GitManualMode'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220917172915_GitManualMode', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220919132739_ComputerMaintenance'
)
BEGIN
    ALTER TABLE [Computer] ADD [Maintenance] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220919132739_ComputerMaintenance'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220919132739_ComputerMaintenance', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220927162921_ArchiveJobTerm'
)
BEGIN
    ALTER TABLE [TerminalInstance] ADD [Archived] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220927162921_ArchiveJobTerm'
)
BEGIN
    ALTER TABLE [Job] ADD [Archived] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220927162921_ArchiveJobTerm'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220927162921_ArchiveJobTerm', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220929123232_GitProxyUrl'
)
BEGIN
    ALTER TABLE [GitSettings] ADD [ProxyUrl] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220929123232_GitProxyUrl'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220929123232_GitProxyUrl', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220930131212_JobScheduleName'
)
BEGIN
    ALTER TABLE [Job] ADD [Schedule] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20220930131212_JobScheduleName'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20220930131212_JobScheduleName', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221026130904_Licenses'
)
BEGIN
    CREATE TABLE [Licenses] (
        [Id] bigint NOT NULL IDENTITY,
        [LicenseText] nvarchar(max) NULL,
        [Licensee] nvarchar(max) NULL,
        [StartDate] datetime2 NOT NULL,
        [EndDate] datetime2 NOT NULL,
        [Seats] int NOT NULL,
        [Product] nvarchar(max) NULL,
        [Status] nvarchar(max) NULL,
        [Developer] bit NOT NULL,
        CONSTRAINT [PK_Licenses] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221026130904_Licenses'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20221026130904_Licenses', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221026133340_GitMode'
)
BEGIN
    ALTER TABLE [GitSettings] ADD [Mode] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221026133340_GitMode'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20221026133340_GitMode', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221102074316_AgentLog'
)
BEGIN
    CREATE TABLE [AgentLogMessages] (
        [Id] bigint NOT NULL IDENTITY,
        [Message] nvarchar(max) NULL,
        [Level] int NOT NULL,
        [Source] nvarchar(450) NULL,
        [TimeStamp] datetime2 NOT NULL,
        CONSTRAINT [PK_AgentLogMessages] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221102074316_AgentLog'
)
BEGIN
    CREATE INDEX [IX_AgentLogMessages_Source] ON [AgentLogMessages] ([Source]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221102074316_AgentLog'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20221102074316_AgentLog', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221110144156_Secrets'
)
BEGIN
    DECLARE @var3 sysname;
    SELECT @var3 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Variable]') AND [c].[name] = N'DeleteSecret');
    IF @var3 IS NOT NULL EXEC(N'ALTER TABLE [Variable] DROP CONSTRAINT [' + @var3 + '];');
    ALTER TABLE [Variable] DROP COLUMN [DeleteSecret];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221110144156_Secrets'
)
BEGIN
    DECLARE @var4 sysname;
    SELECT @var4 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Variable]') AND [c].[name] = N'Description');
    IF @var4 IS NOT NULL EXEC(N'ALTER TABLE [Variable] DROP CONSTRAINT [' + @var4 + '];');
    ALTER TABLE [Variable] DROP COLUMN [Description];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221110144156_Secrets'
)
BEGIN
    DECLARE @var5 sysname;
    SELECT @var5 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Variable]') AND [c].[name] = N'DisableRunAsSupport');
    IF @var5 IS NOT NULL EXEC(N'ALTER TABLE [Variable] DROP CONSTRAINT [' + @var5 + '];');
    ALTER TABLE [Variable] DROP COLUMN [DisableRunAsSupport];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221110144156_Secrets'
)
BEGIN
    DECLARE @var6 sysname;
    SELECT @var6 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Variable]') AND [c].[name] = N'MissingSecret');
    IF @var6 IS NOT NULL EXEC(N'ALTER TABLE [Variable] DROP CONSTRAINT [' + @var6 + '];');
    ALTER TABLE [Variable] DROP COLUMN [MissingSecret];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221110144156_Secrets'
)
BEGIN
    DECLARE @var7 sysname;
    SELECT @var7 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Variable]') AND [c].[name] = N'Password');
    IF @var7 IS NOT NULL EXEC(N'ALTER TABLE [Variable] DROP CONSTRAINT [' + @var7 + '];');
    ALTER TABLE [Variable] DROP COLUMN [Password];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221110144156_Secrets'
)
BEGIN
    DECLARE @var8 sysname;
    SELECT @var8 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Variable]') AND [c].[name] = N'UserName');
    IF @var8 IS NOT NULL EXEC(N'ALTER TABLE [Variable] DROP CONSTRAINT [' + @var8 + '];');
    ALTER TABLE [Variable] DROP COLUMN [UserName];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221110144156_Secrets'
)
BEGIN
    DECLARE @var9 sysname;
    SELECT @var9 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Variable]') AND [c].[name] = N'Vault');
    IF @var9 IS NOT NULL EXEC(N'ALTER TABLE [Variable] DROP CONSTRAINT [' + @var9 + '];');
    ALTER TABLE [Variable] DROP COLUMN [Vault];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221110144156_Secrets'
)
BEGIN
    ALTER TABLE [Variable] ADD [Discriminator] nvarchar(max) NOT NULL DEFAULT N'';
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221110144156_Secrets'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20221110144156_Secrets', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221122100409_NotificationViewed'
)
BEGIN
    ALTER TABLE [Notification] ADD [Viewed] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221122100409_NotificationViewed'
)
BEGIN
    ALTER TABLE [Job] ADD [Batch] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221122100409_NotificationViewed'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20221122100409_NotificationViewed', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221205182407_GitDatabase'
)
BEGIN
    ALTER TABLE [GitSettings] ADD [Bundle] varbinary(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221205182407_GitDatabase'
)
BEGIN
    ALTER TABLE [GitSettings] ADD [BundlePath] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221205182407_GitDatabase'
)
BEGIN
    ALTER TABLE [GitSettings] ADD [BundleTimestamp] datetime2 NOT NULL DEFAULT '0001-01-01T00:00:00.0000000';
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221205182407_GitDatabase'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20221205182407_GitDatabase', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221207170445_ComputerNull'
)
BEGIN
    DECLARE @var10 sysname;
    SELECT @var10 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Job]') AND [c].[name] = N'ComputerId');
    IF @var10 IS NOT NULL EXEC(N'ALTER TABLE [Job] DROP CONSTRAINT [' + @var10 + '];');
    ALTER TABLE [Job] ALTER COLUMN [ComputerId] bigint NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221207170445_ComputerNull'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20221207170445_ComputerNull', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221212142754_SecureFeedback'
)
BEGIN
    ALTER TABLE [JobFeedback] ADD [Secure] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20221212142754_SecureFeedback'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20221212142754_SecureFeedback', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230106105351_Missing'
)
BEGIN
    ALTER TABLE [Variable] ADD [ReadOnly] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230106105351_Missing'
)
BEGIN
    ALTER TABLE [Licenses] ADD [ReadOnly] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230106105351_Missing'
)
BEGIN
    ALTER TABLE [Identity] ADD [CredentialVault] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230106105351_Missing'
)
BEGIN
    ALTER TABLE [Identity] ADD [LocalAccount] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230106105351_Missing'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230106105351_Missing', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230215134531_RunId'
)
BEGIN
    ALTER TABLE [Job] ADD [RunId] uniqueidentifier NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230215134531_RunId'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230215134531_RunId', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230314145632_UserSessions'
)
BEGIN
    CREATE TABLE [UserSessions] (
        [Id] bigint NOT NULL IDENTITY,
        [UserName] nvarchar(max) NULL,
        [ConnectionId] nvarchar(max) NULL,
        [Source] nvarchar(max) NULL,
        [UserAgent] nvarchar(max) NULL,
        [ConnectedTime] datetime2 NOT NULL,
        [DisconnectedTime] datetime2 NULL,
        [ComputerName] nvarchar(max) NULL,
        [IpAddress] nvarchar(max) NULL,
        CONSTRAINT [PK_UserSessions] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230314145632_UserSessions'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230314145632_UserSessions', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230330131812_HealthCheck'
)
BEGIN
    DROP TABLE [ProtectEvents];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230330131812_HealthCheck'
)
BEGIN
    CREATE TABLE [EventHubConnections] (
        [Id] bigint NOT NULL IDENTITY,
        [UserName] nvarchar(max) NULL,
        [RemoteIpAddress] nvarchar(max) NULL,
        [RemoteComputer] nvarchar(max) NULL,
        [EventHub] nvarchar(max) NULL,
        [Computer] nvarchar(max) NULL,
        [Connected] datetime2 NOT NULL,
        [Disconnected] datetime2 NULL,
        CONSTRAINT [PK_EventHubConnections] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230330131812_HealthCheck'
)
BEGIN
    CREATE TABLE [HealthChecks] (
        [Id] bigint NOT NULL IDENTITY,
        [TimeStamp] datetime2 NOT NULL,
        [Name] nvarchar(max) NULL,
        [Status] int NOT NULL,
        [Message] nvarchar(max) NULL,
        [Computer] nvarchar(max) NULL,
        [Current] bit NOT NULL,
        CONSTRAINT [PK_HealthChecks] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230330131812_HealthCheck'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230330131812_HealthCheck', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230405170727_RemoveAgentLogMessage'
)
BEGIN
    DROP TABLE [AgentLogMessages];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230405170727_RemoveAgentLogMessage'
)
BEGIN
    ALTER TABLE [AppToken] ADD [LastUsed] datetime2 NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230405170727_RemoveAgentLogMessage'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230405170727_RemoveAgentLogMessage', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230410213556_JobCascadeDelete'
)
BEGIN
    ALTER TABLE [JobFeedback] DROP CONSTRAINT [FK_JobFeedback_Job_JobId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230410213556_JobCascadeDelete'
)
BEGIN
    ALTER TABLE [JobOutput] DROP CONSTRAINT [FK_JobOutput_Job_JobId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230410213556_JobCascadeDelete'
)
BEGIN
    ALTER TABLE [JobParameter] DROP CONSTRAINT [FK_JobParameter_Job_JobId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230410213556_JobCascadeDelete'
)
BEGIN
    ALTER TABLE [JobPipelineOutput] DROP CONSTRAINT [FK_JobPipelineOutput_Job_JobId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230410213556_JobCascadeDelete'
)
BEGIN
    ALTER TABLE [Notification] DROP CONSTRAINT [FK_Notification_Job_JobId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230410213556_JobCascadeDelete'
)
BEGIN
    ALTER TABLE [JobFeedback] ADD CONSTRAINT [FK_JobFeedback_Job_JobId] FOREIGN KEY ([JobId]) REFERENCES [Job] ([Id]) ON DELETE CASCADE;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230410213556_JobCascadeDelete'
)
BEGIN
    ALTER TABLE [JobOutput] ADD CONSTRAINT [FK_JobOutput_Job_JobId] FOREIGN KEY ([JobId]) REFERENCES [Job] ([Id]) ON DELETE CASCADE;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230410213556_JobCascadeDelete'
)
BEGIN
    ALTER TABLE [JobParameter] ADD CONSTRAINT [FK_JobParameter_Job_JobId] FOREIGN KEY ([JobId]) REFERENCES [Job] ([Id]) ON DELETE CASCADE;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230410213556_JobCascadeDelete'
)
BEGIN
    ALTER TABLE [JobPipelineOutput] ADD CONSTRAINT [FK_JobPipelineOutput_Job_JobId] FOREIGN KEY ([JobId]) REFERENCES [Job] ([Id]) ON DELETE CASCADE;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230410213556_JobCascadeDelete'
)
BEGIN
    ALTER TABLE [Notification] ADD CONSTRAINT [FK_Notification_Job_JobId] FOREIGN KEY ([JobId]) REFERENCES [Job] ([Id]) ON DELETE CASCADE;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230410213556_JobCascadeDelete'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230410213556_JobCascadeDelete', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230416165440_LogEntries'
)
BEGIN
    CREATE TABLE [LogEntry] (
        [LogId] bigint NOT NULL IDENTITY,
        [EntryId] nvarchar(max) NULL,
        [TimeStamp] datetime2 NOT NULL,
        [Message] nvarchar(450) NULL,
        [Level] nvarchar(450) NULL,
        [Resource] nvarchar(450) NULL,
        [Scope] nvarchar(450) NULL,
        [Feature] nvarchar(450) NULL,
        [NodeName] nvarchar(450) NULL,
        [MessageTemplate] nvarchar(max) NULL,
        [Exception] nvarchar(max) NULL,
        [Properties] nvarchar(max) NULL,
        CONSTRAINT [PK_LogEntry] PRIMARY KEY ([LogId])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230416165440_LogEntries'
)
BEGIN
    CREATE INDEX [IX_LogEntry_Feature] ON [LogEntry] ([Feature]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230416165440_LogEntries'
)
BEGIN
    CREATE INDEX [IX_LogEntry_Level] ON [LogEntry] ([Level]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230416165440_LogEntries'
)
BEGIN
    CREATE INDEX [IX_LogEntry_LogId] ON [LogEntry] ([LogId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230416165440_LogEntries'
)
BEGIN
    CREATE INDEX [IX_LogEntry_Message] ON [LogEntry] ([Message]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230416165440_LogEntries'
)
BEGIN
    CREATE INDEX [IX_LogEntry_NodeName] ON [LogEntry] ([NodeName]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230416165440_LogEntries'
)
BEGIN
    CREATE INDEX [IX_LogEntry_Resource] ON [LogEntry] ([Resource]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230416165440_LogEntries'
)
BEGIN
    CREATE INDEX [IX_LogEntry_Scope] ON [LogEntry] ([Scope]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230416165440_LogEntries'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230416165440_LogEntries', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230505135137_LogExports'
)
BEGIN
    CREATE TABLE [LogExports] (
        [Id] bigint NOT NULL IDENTITY,
        [IdentityId] bigint NULL,
        [Timestamp] datetime2 NOT NULL,
        [Completed] datetime2 NULL,
        [Content] nvarchar(max) NULL,
        [Parameters] nvarchar(max) NULL,
        [Type] int NOT NULL,
        CONSTRAINT [PK_LogExports] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_LogExports_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230505135137_LogExports'
)
BEGIN
    CREATE INDEX [IX_LogExports_IdentityId] ON [LogExports] ([IdentityId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230505135137_LogExports'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230505135137_LogExports', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230508164409_VariableValues'
)
BEGIN
    ALTER TABLE [Variable] ADD [Database] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230508164409_VariableValues'
)
BEGIN
    CREATE TABLE [VariableValues] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Value] nvarchar(max) NULL,
        CONSTRAINT [PK_VariableValues] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230508164409_VariableValues'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230508164409_VariableValues', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230512092443_DeletedComputer'
)
BEGIN
    ALTER TABLE [Computer] ADD [Deleted] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230512092443_DeletedComputer'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230512092443_DeletedComputer', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230520152944_SecretRole'
)
BEGIN
    ALTER TABLE [Job] ADD [Roles] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230520152944_SecretRole'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230520152944_SecretRole', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230628124949_RefreshToken'
)
BEGIN
    ALTER TABLE [Job] ADD [RefreshToken] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230628124949_RefreshToken'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230628124949_RefreshToken', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230629165358_ConnectionId'
)
BEGIN
    ALTER TABLE [EventHubConnections] ADD [ConnectionId] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230629165358_ConnectionId'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230629165358_ConnectionId', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230821140538_GitBundle'
)
BEGIN
    CREATE TABLE [GitBundles] (
        [Id] bigint NOT NULL IDENTITY,
        [Bundle] varbinary(max) NULL,
        [BundleTimestamp] datetime2 NOT NULL,
        CONSTRAINT [PK_GitBundles] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230821140538_GitBundle'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230821140538_GitBundle', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230906152734_MessageLength'
)
BEGIN
    DROP INDEX [IX_LogEntry_Message] ON [LogEntry];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230906152734_MessageLength'
)
BEGIN
    DECLARE @var11 sysname;
    SELECT @var11 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[LogEntry]') AND [c].[name] = N'Message');
    IF @var11 IS NOT NULL EXEC(N'ALTER TABLE [LogEntry] DROP CONSTRAINT [' + @var11 + '];');
    ALTER TABLE [LogEntry] ALTER COLUMN [Message] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230906152734_MessageLength'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230906152734_MessageLength', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230913130803_ProductVersion'
)
BEGIN
    CREATE TABLE [ProductVersions] (
        [Id] bigint NOT NULL IDENTITY,
        [Version] nvarchar(max) NULL,
        [InstallDate] datetime2 NOT NULL,
        CONSTRAINT [PK_ProductVersions] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230913130803_ProductVersion'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230913130803_ProductVersion', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230916184707_UserSettings'
)
BEGIN
    ALTER TABLE [Identity] ADD [Settings] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230916184707_UserSettings'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230916184707_UserSettings', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230922163944_LoginError'
)
BEGIN
    ALTER TABLE [Computer] ADD [LoginErrorMessage] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20230922163944_LoginError'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20230922163944_LoginError', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20231023225240_ComputerTags'
)
BEGIN
    CREATE TABLE [ComputerTag] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Value] nvarchar(max) NULL,
        [Static] bit NOT NULL,
        [ComputerId] bigint NULL,
        CONSTRAINT [PK_ComputerTag] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_ComputerTag_Computer_ComputerId] FOREIGN KEY ([ComputerId]) REFERENCES [Computer] ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20231023225240_ComputerTags'
)
BEGIN
    CREATE INDEX [IX_ComputerTag_ComputerId] ON [ComputerTag] ([ComputerId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20231023225240_ComputerTags'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20231023225240_ComputerTags', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20231108132130_RemoveTimeStampsVariables'
)
BEGIN
    DECLARE @var12 sysname;
    SELECT @var12 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Variable]') AND [c].[name] = N'CreatedTime');
    IF @var12 IS NOT NULL EXEC(N'ALTER TABLE [Variable] DROP CONSTRAINT [' + @var12 + '];');
    ALTER TABLE [Variable] DROP COLUMN [CreatedTime];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20231108132130_RemoveTimeStampsVariables'
)
BEGIN
    DECLARE @var13 sysname;
    SELECT @var13 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Variable]') AND [c].[name] = N'UpdatedTime');
    IF @var13 IS NOT NULL EXEC(N'ALTER TABLE [Variable] DROP CONSTRAINT [' + @var13 + '];');
    ALTER TABLE [Variable] DROP COLUMN [UpdatedTime];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20231108132130_RemoveTimeStampsVariables'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20231108132130_RemoveTimeStampsVariables', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20231204154321_SubModules'
)
BEGIN
    ALTER TABLE [GitSettings] ADD [UpdateSubmodules] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20231204154321_SubModules'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20231204154321_SubModules', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240116130751_HangfireInfo'
)
BEGIN
    ALTER TABLE [Computer] ADD [HangfireServerId] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240116130751_HangfireInfo'
)
BEGIN
    ALTER TABLE [Computer] ADD [HangfireWorkerCounter] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240116130751_HangfireInfo'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240116130751_HangfireInfo', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240117144819_ComputerVersion'
)
BEGIN
    ALTER TABLE [Computer] ADD [Version] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240117144819_ComputerVersion'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240117144819_ComputerVersion', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240126145425_GitPaused'
)
BEGIN
    ALTER TABLE [GitSettings] ADD [Paused] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240126145425_GitPaused'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240126145425_GitPaused', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240214125140_NotNullJob'
)
BEGIN
    ALTER TABLE [Job] DROP CONSTRAINT [FK_Job_Identity_IdentityId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240214125140_NotNullJob'
)
BEGIN
    DECLARE @var14 sysname;
    SELECT @var14 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Variable]') AND [c].[name] = N'Discriminator');
    IF @var14 IS NOT NULL EXEC(N'ALTER TABLE [Variable] DROP CONSTRAINT [' + @var14 + '];');
    ALTER TABLE [Variable] ALTER COLUMN [Discriminator] nvarchar(21) NOT NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240214125140_NotNullJob'
)
BEGIN
    ALTER TABLE [Licenses] ADD [Source] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240214125140_NotNullJob'
)
BEGIN
    DECLARE @var15 sysname;
    SELECT @var15 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Job]') AND [c].[name] = N'IdentityId');
    IF @var15 IS NOT NULL EXEC(N'ALTER TABLE [Job] DROP CONSTRAINT [' + @var15 + '];');
    ALTER TABLE [Job] ALTER COLUMN [IdentityId] bigint NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240214125140_NotNullJob'
)
BEGIN
    ALTER TABLE [Job] ADD CONSTRAINT [FK_Job_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240214125140_NotNullJob'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240214125140_NotNullJob', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240218162601_JobComputerNull'
)
BEGIN
    ALTER TABLE [Job] DROP CONSTRAINT [FK_Job_Computer_ComputerId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240218162601_JobComputerNull'
)
BEGIN
    ALTER TABLE [Job] ADD CONSTRAINT [FK_Job_Computer_ComputerId] FOREIGN KEY ([ComputerId]) REFERENCES [Computer] ([Id]) ON DELETE CASCADE;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240218162601_JobComputerNull'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240218162601_JobComputerNull', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240308135138_DataItems'
)
BEGIN
    CREATE TABLE [Dataitems] (
        [Id] bigint NOT NULL IDENTITY,
        [Key] nvarchar(max) NULL,
        [Created] datetime2 NOT NULL,
        [LastRead] datetime2 NULL,
        [Expiration] datetime2 NULL,
        [SlidingExpiration] time NULL,
        [Value] nvarchar(max) NULL,
        [Role] nvarchar(max) NULL,
        [Identity] nvarchar(max) NULL,
        CONSTRAINT [PK_Dataitems] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240308135138_DataItems'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240308135138_DataItems', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240308140654_DataItems2'
)
BEGIN
    DECLARE @var16 sysname;
    SELECT @var16 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Dataitems]') AND [c].[name] = N'LastRead');
    IF @var16 IS NOT NULL EXEC(N'ALTER TABLE [Dataitems] DROP CONSTRAINT [' + @var16 + '];');
    ALTER TABLE [Dataitems] ALTER COLUMN [LastRead] datetimeoffset NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240308140654_DataItems2'
)
BEGIN
    DECLARE @var17 sysname;
    SELECT @var17 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Dataitems]') AND [c].[name] = N'Expiration');
    IF @var17 IS NOT NULL EXEC(N'ALTER TABLE [Dataitems] DROP CONSTRAINT [' + @var17 + '];');
    ALTER TABLE [Dataitems] ALTER COLUMN [Expiration] datetimeoffset NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240308140654_DataItems2'
)
BEGIN
    DECLARE @var18 sysname;
    SELECT @var18 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Dataitems]') AND [c].[name] = N'Created');
    IF @var18 IS NOT NULL EXEC(N'ALTER TABLE [Dataitems] DROP CONSTRAINT [' + @var18 + '];');
    ALTER TABLE [Dataitems] ALTER COLUMN [Created] datetimeoffset NOT NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240308140654_DataItems2'
)
BEGIN
    ALTER TABLE [Dataitems] ADD [AbsoluteExpirationRelativeToNow] time NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240308140654_DataItems2'
)
BEGIN
    ALTER TABLE [Dataitems] ADD [Updated] datetimeoffset NOT NULL DEFAULT '0001-01-01T00:00:00.0000000+00:00';
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240308140654_DataItems2'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240308140654_DataItems2', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240312212421_FileSync'
)
BEGIN
    ALTER TABLE [Computer] ADD [FileSyncTimestamp] datetime2 NOT NULL DEFAULT '0001-01-01T00:00:00.0000000';
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240312212421_FileSync'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240312212421_FileSync', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240314222728_ScriptTable'
)
BEGIN
    CREATE TABLE [Scripts] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NOT NULL,
        [Description] nvarchar(max) NULL,
        [CreatedTime] datetime2 NOT NULL,
        [ManualTime] float NOT NULL,
        [TimeOut] float NOT NULL,
        [CommitId] nvarchar(max) NULL,
        [Content] nvarchar(max) NULL,
        [Status] int NOT NULL,
        [FullPath] nvarchar(max) NULL,
        [RequiredPowerShellVersion] nvarchar(max) NULL,
        [Environment] nvarchar(max) NULL,
        [ErrorAction] int NOT NULL,
        [InformationAction] int NOT NULL,
        [Verbose] bit NOT NULL,
        [Debug] bit NOT NULL,
        [CommitNotes] nvarchar(max) NULL,
        [DisableManualInvocation] bit NOT NULL,
        [MaxHistory] int NOT NULL,
        [ConcurrentJobs] int NOT NULL,
        [Credential] nvarchar(max) NULL,
        [AccessControls] int NOT NULL,
        [RetryLimit] int NOT NULL,
        [Anonymous] bit NOT NULL,
        [DiscardPipeline] bit NOT NULL,
        [LongDescription] nvarchar(max) NULL,
        [Links] nvarchar(max) NULL,
        [DefaultParameterSet] nvarchar(max) NULL,
        [LoadProfile] bit NOT NULL,
        [WorkingDirectory] nvarchar(max) NULL,
        [Folder] nvarchar(max) NULL,
        [ReadOnly] bit NOT NULL,
        [ResolvedPath] nvarchar(max) NULL,
        [Module] nvarchar(max) NULL,
        [Command] nvarchar(max) NULL,
        [Role] nvarchar(max) NULL,
        [Documentation] nvarchar(max) NULL,
        CONSTRAINT [PK_Scripts] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240314222728_ScriptTable'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240314222728_ScriptTable', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240324214735_AuthenticationMethods'
)
BEGIN
    CREATE TABLE [AuthenticationMethods] (
        [Id] bigint NOT NULL IDENTITY,
        [Type] int NOT NULL,
        [Settings] nvarchar(max) NULL,
        [Disabled] bit NOT NULL,
        [CallbackPath] nvarchar(max) NULL,
        [ClientId] nvarchar(max) NULL,
        [ClientSecret] nvarchar(max) NULL,
        [Resource] nvarchar(max) NULL,
        [Authority] nvarchar(max) NULL,
        [ResponseType] nvarchar(max) NULL,
        [SaveTokens] bit NOT NULL,
        [UseTokenLifetime] bit NOT NULL,
        [GetClaimsFromUserInfoEndpoint] bit NOT NULL,
        [Scopes] nvarchar(max) NULL,
        [CorrelationCookieSameSite] nvarchar(max) NULL,
        [MetadataAddress] nvarchar(max) NULL,
        [Wtrealm] nvarchar(max) NULL,
        [Wreply] nvarchar(max) NULL,
        [EntityId] nvarchar(max) NULL,
        [IdentityProviderEntityId] nvarchar(max) NULL,
        [ServiceCertificate] nvarchar(max) NULL,
        [ServiceCertificatePassword] nvarchar(max) NULL,
        [LoadMetadata] bit NOT NULL,
        [SigningKey] nvarchar(max) NULL,
        [SingleSignOnServiceUrl] nvarchar(max) NULL,
        [RequireMfa] bit NOT NULL,
        [LogoutUrl] nvarchar(max) NULL,
        [Source] nvarchar(max) NULL,
        [AllowUnsolicitedAuthnResponse] bit NOT NULL,
        CONSTRAINT [PK_AuthenticationMethods] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240324214735_AuthenticationMethods'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240324214735_AuthenticationMethods', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240324221257_PersistenceSetting'
)
BEGIN
    CREATE TABLE [PersistenceSettings] (
        [Id] bigint NOT NULL IDENTITY,
        [Type] nvarchar(max) NULL,
        [FileSystem] bit NOT NULL,
        [Database] bit NOT NULL,
        CONSTRAINT [PK_PersistenceSettings] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240324221257_PersistenceSetting'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240324221257_PersistenceSetting', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240325211858_TagDb'
)
BEGIN
    CREATE TABLE [Roles] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NOT NULL,
        [Description] nvarchar(max) NULL,
        [Policy] nvarchar(max) NULL,
        [ClaimType] nvarchar(max) NULL,
        [ClaimValue] nvarchar(max) NULL,
        [Disabled] bit NOT NULL,
        [ReadOnly] bit NOT NULL,
        [DefaultRoute] nvarchar(max) NULL,
        [RoleId] bigint NULL,
        CONSTRAINT [PK_Roles] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_Roles_Roles_RoleId] FOREIGN KEY ([RoleId]) REFERENCES [Roles] ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240325211858_TagDb'
)
BEGIN
    CREATE TABLE [Tags] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NOT NULL,
        [Color] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [Editable] bit NOT NULL,
        [ReadOnly] bit NOT NULL,
        [FontColor] nvarchar(max) NULL,
        CONSTRAINT [PK_Tags] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240325211858_TagDb'
)
BEGIN
    CREATE INDEX [IX_Roles_RoleId] ON [Roles] ([RoleId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240325211858_TagDb'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240325211858_TagDb', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240325213555_MiddlewareDb'
)
BEGIN
    CREATE TABLE [PowerShellMiddlewares] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Order] int NOT NULL,
        [ScriptBlock] nvarchar(max) NULL,
        CONSTRAINT [PK_PowerShellMiddlewares] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240325213555_MiddlewareDb'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240325213555_MiddlewareDb', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240325213831_BrandingDb'
)
BEGIN
    CREATE TABLE [Branding] (
        [Id] bigint NOT NULL IDENTITY,
        [LoginPageImage] nvarchar(max) NULL,
        [AppBarLogo] nvarchar(max) NULL,
        [AdminConsoleTitle] nvarchar(max) NULL,
        [PrimaryColor] nvarchar(max) NULL,
        [SecondaryColor] nvarchar(max) NULL,
        [PrimaryFontColor] nvarchar(max) NULL,
        [SecondaryFontColor] nvarchar(max) NULL,
        [HeaderFontColor] nvarchar(max) NULL,
        [HeaderColor] nvarchar(max) NULL,
        [Copyright] nvarchar(max) NULL,
        [CssStylesheet] nvarchar(max) NULL,
        [CssStylesheetIntegrity] nvarchar(max) NULL,
        [PageNotFoundDescription] nvarchar(max) NULL,
        [NotAuthorizedDescription] nvarchar(max) NULL,
        [AppNotRunningDescription] nvarchar(max) NULL,
        [PageNotFoundTitle] nvarchar(max) NULL,
        [NotAuthorizedTitle] nvarchar(max) NULL,
        [LoginPageTitle] nvarchar(max) NULL,
        [FavIcon] nvarchar(max) NULL,
        [LoginPageText] nvarchar(max) NULL,
        [LoginPageDescription] nvarchar(max) NULL,
        [LoggedOut] nvarchar(max) NULL,
        [LoggedOutDescription] nvarchar(max) NULL,
        CONSTRAINT [PK_Branding] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240325213831_BrandingDb'
)
BEGIN
    CREATE TABLE [LoginPageLink] (
        [Id] bigint NOT NULL IDENTITY,
        [Text] nvarchar(max) NULL,
        [Url] nvarchar(max) NULL,
        [Icon] nvarchar(max) NULL,
        [BrandingId] bigint NULL,
        CONSTRAINT [PK_LoginPageLink] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_LoginPageLink_Branding_BrandingId] FOREIGN KEY ([BrandingId]) REFERENCES [Branding] ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240325213831_BrandingDb'
)
BEGIN
    CREATE INDEX [IX_LoginPageLink_BrandingId] ON [LoginPageLink] ([BrandingId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240325213831_BrandingDb'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240325213831_BrandingDb', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326131902_PublishedFolders'
)
BEGIN
    CREATE TABLE [PublishedFolders] (
        [Id] bigint NOT NULL IDENTITY,
        [RequestPath] nvarchar(max) NOT NULL,
        [Path] nvarchar(max) NOT NULL,
        [Role] nvarchar(max) NULL,
        [Authentication] bit NOT NULL,
        [DefaultDocument] nvarchar(max) NULL,
        [Impersonation] bit NOT NULL,
        [ReadOnly] bit NOT NULL,
        [Name] nvarchar(max) NOT NULL,
        CONSTRAINT [PK_PublishedFolders] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326131902_PublishedFolders'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240326131902_PublishedFolders', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326204711_BlazorPage'
)
BEGIN
    CREATE TABLE [BlazorPages] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Url] nvarchar(max) NULL,
        [RazorContent] nvarchar(max) NULL,
        [PowerShellContent] nvarchar(max) NULL,
        [RazorPath] nvarchar(max) NULL,
        [PowerShellPath] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [Roles] nvarchar(max) NULL,
        [Authentication] bit NOT NULL,
        [ReadOnly] bit NOT NULL,
        [Title] nvarchar(max) NULL,
        CONSTRAINT [PK_BlazorPages] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326204711_BlazorPage'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240326204711_BlazorPage', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326210346_EventHubs'
)
BEGIN
    CREATE TABLE [EventHubs] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NOT NULL,
        [Description] nvarchar(max) NULL,
        [Role] nvarchar(max) NULL,
        [Authenticated] bit NOT NULL,
        CONSTRAINT [PK_EventHubs] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326210346_EventHubs'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240326210346_EventHubs', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326211431_Terminals'
)
BEGIN
    CREATE TABLE [Terminals] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [Environment] nvarchar(max) NULL,
        [Credential] nvarchar(max) NULL,
        [Role] nvarchar(max) NULL,
        [KeepHistory] bit NOT NULL,
        [IdleTimeout] int NOT NULL,
        [ReadOnly] bit NOT NULL,
        CONSTRAINT [PK_Terminals] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326211431_Terminals'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240326211431_Terminals', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326212615_ComputerGroups'
)
BEGIN
    CREATE TABLE [ComputerGroups] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [Tags] nvarchar(max) NULL,
        CONSTRAINT [PK_ComputerGroups] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326212615_ComputerGroups'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240326212615_ComputerGroups', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326213428_Settings'
)
BEGIN
    CREATE TABLE [Settings] (
        [Id] bigint NOT NULL IDENTITY,
        [LoggingFilePath] nvarchar(max) NULL,
        [LogLevel] nvarchar(max) NULL,
        [MicrosoftLogLevel] nvarchar(max) NULL,
        [DefaultPowerShellVersion] nvarchar(max) NULL,
        [DefaultEnvironment] nvarchar(max) NULL,
        [RepositoryPath] nvarchar(max) NULL,
        [DatabasePath] nvarchar(max) NULL,
        [PathDivider] nvarchar(1) NOT NULL,
        [GroomDays] int NOT NULL,
        [ConcurrentJobLimit] int NOT NULL,
        [Telemetry] bit NOT NULL,
        [HideApi] bit NOT NULL,
        [HideAutomation] bit NOT NULL,
        [HideDashboard] bit NOT NULL,
        [HideHomePage] bit NOT NULL,
        [DisableAutoReload] bit NOT NULL,
        [SecurityPowerShellVersion] nvarchar(max) NULL,
        [SecurityEnvironment] nvarchar(max) NULL,
        [ApiEnvironment] nvarchar(max) NULL,
        [DefaultPage] nvarchar(max) NULL,
        [RateLimitIpAddressAllowList] nvarchar(max) NULL,
        [RateLimitEndpointAllowList] nvarchar(max) NULL,
        [RateLimitClientAllowList] nvarchar(max) NULL,
        [DisableUpdateCheck] bit NOT NULL,
        [ScriptBaseFolder] nvarchar(max) NULL,
        [AdminConsoleTitle] nvarchar(max) NULL,
        [AdminConsoleLogo] nvarchar(max) NULL,
        [SessionTimeout] int NOT NULL,
        [GitRemote] nvarchar(max) NULL,
        [GitBranch] nvarchar(max) NULL,
        [GitSyncBehavior] int NOT NULL,
        [GitSyncEnabled] bit NOT NULL,
        [GroomInterval] int NOT NULL,
        [NotificationLevel] int NOT NULL,
        [ProxyUri] nvarchar(max) NULL,
        [ProxyCredential] nvarchar(max) NULL,
        [JobHandshakeTimeout] int NOT NULL,
        [HideRunAs] bit NOT NULL,
        [FallbackLanguageId] nvarchar(max) NULL,
        [Splatting] bit NOT NULL,
        [FavIcon] nvarchar(max) NULL,
        [ExperimentalFeatures] int NOT NULL,
        [DisabledFeatures] int NOT NULL,
        [LimitIdentities] bit NOT NULL,
        [DontLoadProfile] bit NOT NULL,
        [WindowsCompatEnabled] bit NOT NULL,
        [EnhancedAppTokenSecurity] bit NOT NULL,
        [ReadOnly] bit NOT NULL,
        [DefaultDashboardTheme] nvarchar(max) NULL,
        [UseLogoSize] bit NOT NULL,
        [DarkTheme] bit NOT NULL,
        [HideEnvironment] bit NOT NULL,
        [HideRunOn] bit NOT NULL,
        [DisableFormatOnSave] bit NOT NULL,
        [ContentSecurityPolicy] nvarchar(max) NULL,
        [LogGroomDays] int NOT NULL,
        [PreformattedJobOutput] bit NOT NULL,
        [ModuleDiscoveryFrequency] nvarchar(max) NULL,
        [DebuggerEnvironment] nvarchar(max) NULL,
        [FileEncoding] nvarchar(max) NULL,
        [MaxJobMemory] int NOT NULL,
        [JobRunId] bit NOT NULL,
        [ApiBaseFolder] nvarchar(max) NULL,
        CONSTRAINT [PK_Settings] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326213428_Settings'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240326213428_Settings', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326220954_Environments'
)
BEGIN
    CREATE TABLE [ExecutionEnvironments] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NOT NULL,
        [Version] nvarchar(max) NULL,
        [Path] nvarchar(max) NULL,
        [Arguments] nvarchar(max) NULL,
        [Modules] nvarchar(max) NULL,
        [Variables] nvarchar(max) NULL,
        [PersistentRunspace] bit NOT NULL,
        [PSModulePath] nvarchar(max) NULL,
        [StartupScript] nvarchar(max) NULL,
        [RunspaceRecycling] bit NOT NULL,
        [MaxRunspaces] int NOT NULL,
        [EnableDebugger] bit NOT NULL,
        [MaxVirtualMemory] bigint NOT NULL,
        [RecycleSchedule] nvarchar(max) NULL,
        [Credential] nvarchar(max) NULL,
        [ReadOnly] bit NOT NULL,
        [Description] nvarchar(max) NULL,
        [Reload] bit NOT NULL,
        [DisableImplicitWinCompat] bit NOT NULL,
        [Language] nvarchar(max) NULL,
        [Minimal] bit NOT NULL,
        [Disabled] bit NOT NULL,
        [ProcessStartupScript] nvarchar(max) NULL,
        [SupportedFeatures] nvarchar(max) NULL,
        CONSTRAINT [PK_ExecutionEnvironments] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326220954_Environments'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240326220954_Environments', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326222338_Schedules'
)
BEGIN
    CREATE TABLE [Schedules] (
        [Id] bigint NOT NULL IDENTITY,
        [IdentityId] bigint NULL,
        [AppTokenId] bigint NULL,
        [Cron] nvarchar(max) NULL,
        [NextExecution] datetime2 NULL,
        [Description] nvarchar(max) NULL,
        [Script] nvarchar(max) NULL,
        [TimeZoneString] nvarchar(max) NULL,
        [Continuous] bit NOT NULL,
        [Delay] time NULL,
        [Credential] nvarchar(max) NULL,
        [OneTime] datetime2 NULL,
        [Environment] nvarchar(max) NULL,
        [Name] nvarchar(max) NULL,
        [Paused] bit NOT NULL,
        [Timeout] int NOT NULL,
        [Condition] nvarchar(max) NULL,
        [RandomDelay] bit NOT NULL,
        [Computer] nvarchar(max) NULL,
        [ReadOnly] bit NOT NULL,
        [OneWayOneTime] bit NOT NULL,
        [RandomDelayMaximum] int NOT NULL,
        CONSTRAINT [PK_Schedules] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_Schedules_AppToken_AppTokenId] FOREIGN KEY ([AppTokenId]) REFERENCES [AppToken] ([Id]),
        CONSTRAINT [FK_Schedules_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326222338_Schedules'
)
BEGIN
    CREATE TABLE [ScheduleParameter] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Value] nvarchar(max) NULL,
        [Type] nvarchar(max) NULL,
        [Variable] bit NOT NULL,
        [ScheduleId] bigint NULL,
        CONSTRAINT [PK_ScheduleParameter] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_ScheduleParameter_Schedules_ScheduleId] FOREIGN KEY ([ScheduleId]) REFERENCES [Schedules] ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326222338_Schedules'
)
BEGIN
    CREATE INDEX [IX_ScheduleParameter_ScheduleId] ON [ScheduleParameter] ([ScheduleId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326222338_Schedules'
)
BEGIN
    CREATE INDEX [IX_Schedules_AppTokenId] ON [Schedules] ([AppTokenId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326222338_Schedules'
)
BEGIN
    CREATE INDEX [IX_Schedules_IdentityId] ON [Schedules] ([IdentityId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326222338_Schedules'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240326222338_Schedules', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326222848_Triggers'
)
BEGIN
    ALTER TABLE [ScheduleParameter] ADD [TriggerId] bigint NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326222848_Triggers'
)
BEGIN
    CREATE TABLE [Triggers] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Script] nvarchar(max) NULL,
        [EventType] int NOT NULL,
        [Environment] nvarchar(max) NULL,
        [TriggerScript] nvarchar(max) NULL,
        [Dashboard] nvarchar(max) NULL,
        [Delay] int NOT NULL,
        [Computer] nvarchar(max) NULL,
        [ReadOnly] bit NOT NULL,
        [Condition] nvarchar(max) NULL,
        CONSTRAINT [PK_Triggers] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326222848_Triggers'
)
BEGIN
    CREATE INDEX [IX_ScheduleParameter_TriggerId] ON [ScheduleParameter] ([TriggerId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326222848_Triggers'
)
BEGIN
    ALTER TABLE [ScheduleParameter] ADD CONSTRAINT [FK_ScheduleParameter_Triggers_TriggerId] FOREIGN KEY ([TriggerId]) REFERENCES [Triggers] ([Id]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326222848_Triggers'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240326222848_Triggers', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326223419_BlazorComponents'
)
BEGIN
    CREATE TABLE [CustomBlazorComponents] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [BlazorContent] nvarchar(max) NULL,
        [PowerShellContent] nvarchar(max) NULL,
        [Parameters] nvarchar(max) NULL,
        [ReadOnly] bit NOT NULL,
        CONSTRAINT [PK_CustomBlazorComponents] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326223419_BlazorComponents'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240326223419_BlazorComponents', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326224134_EndpointDocs'
)
BEGIN
    CREATE TABLE [EndpointDocumentation] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [Authentication] bit NOT NULL,
        [Role] nvarchar(max) NULL,
        [Definition] nvarchar(max) NULL,
        [ReadOnly] bit NOT NULL,
        [Url] nvarchar(max) NULL,
        CONSTRAINT [PK_EndpointDocumentation] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326224134_EndpointDocs'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240326224134_EndpointDocs', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326225301_Endpoints'
)
BEGIN
    ALTER TABLE [Tags] ADD [EndpointId] bigint NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326225301_Endpoints'
)
BEGIN
    CREATE TABLE [Endpoints] (
        [Id] bigint NOT NULL IDENTITY,
        [Url] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [Method] nvarchar(max) NULL,
        [ScriptBlock] nvarchar(max) NULL,
        [Authentication] bit NOT NULL,
        [Role] nvarchar(max) NULL,
        [RegEx] bit NOT NULL,
        [ErrorAction] int NOT NULL,
        [Timeout] int NOT NULL,
        [Path] nvarchar(max) NULL,
        [Environment] nvarchar(max) NULL,
        [FullPath] nvarchar(max) NULL,
        [PersistentLog] bit NOT NULL,
        [ReadOnly] bit NOT NULL,
        [Documentation] nvarchar(max) NULL,
        [Module] nvarchar(max) NULL,
        [Command] nvarchar(max) NULL,
        [ComputerGroup] nvarchar(max) NULL,
        CONSTRAINT [PK_Endpoints] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326225301_Endpoints'
)
BEGIN
    CREATE INDEX [IX_Tags_EndpointId] ON [Tags] ([EndpointId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326225301_Endpoints'
)
BEGIN
    ALTER TABLE [Tags] ADD CONSTRAINT [FK_Tags_Endpoints_EndpointId] FOREIGN KEY ([EndpointId]) REFERENCES [Endpoints] ([Id]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240326225301_Endpoints'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240326225301_Endpoints', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240327152919_Dashboards'
)
BEGIN
    ALTER TABLE [Tags] ADD [DashboardId] bigint NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240327152919_Dashboards'
)
BEGIN
    CREATE TABLE [Apps] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NOT NULL,
        [FilePath] nvarchar(max) NULL,
        [BaseUrl] nvarchar(max) NOT NULL,
        [Environment] nvarchar(max) NULL,
        [ProcessId] int NOT NULL,
        [ProcessName] nvarchar(max) NULL,
        [Status] int NOT NULL,
        [Authenticated] bit NOT NULL,
        [Role] nvarchar(max) NULL,
        [Content] nvarchar(max) NULL,
        [GrantAppToken] bit NOT NULL,
        [Debug] bit NOT NULL,
        [DisableAutoStart] bit NOT NULL,
        [DisableStartupLog] bit NOT NULL,
        [SessionTimeout] int NOT NULL,
        [IdleTimeout] int NULL,
        [Deployed] bit NOT NULL,
        [AutoDeploy] bit NOT NULL,
        [Description] nvarchar(max) NULL,
        [Credential] nvarchar(max) NULL,
        [DisableErrorToast] bit NOT NULL,
        [Maintenance] bit NOT NULL,
        [Template] nvarchar(max) NULL,
        [ReadOnly] bit NOT NULL,
        [VerboseErrorMessages] bit NOT NULL,
        [DisableInteractiveHost] bit NOT NULL,
        [Module] nvarchar(max) NULL,
        [Command] nvarchar(max) NULL,
        [FavIcon] nvarchar(max) NULL,
        [AccessControls] int NOT NULL,
        [Hidden] bit NOT NULL,
        [OnSessionTimeout] nvarchar(max) NULL,
        [ComputerGroup] nvarchar(max) NULL,
        [StartTime] datetime2 NULL,
        [DeployTime] datetime2 NULL,
        [ModuleContent] nvarchar(max) NULL,
        CONSTRAINT [PK_Apps] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240327152919_Dashboards'
)
BEGIN
    CREATE INDEX [IX_Tags_DashboardId] ON [Tags] ([DashboardId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240327152919_Dashboards'
)
BEGIN
    ALTER TABLE [Tags] ADD CONSTRAINT [FK_Tags_Apps_DashboardId] FOREIGN KEY ([DashboardId]) REFERENCES [Apps] ([Id]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240327152919_Dashboards'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240327152919_Dashboards', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240327160016_Folders'
)
BEGIN
    CREATE TABLE [Folders] (
        [Id] bigint NOT NULL IDENTITY,
        [Path] nvarchar(max) NULL,
        [Type] int NOT NULL,
        [ReadOnly] bit NOT NULL,
        CONSTRAINT [PK_Folders] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240327160016_Folders'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240327160016_Folders', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240327194404_ComputerReadOnly'
)
BEGIN
    ALTER TABLE [Computer] ADD [ReadOnly] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240327194404_ComputerReadOnly'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240327194404_ComputerReadOnly', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240327200224_VariableScope'
)
BEGIN
    ALTER TABLE [Variable] ADD [Scope] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240327200224_VariableScope'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240327200224_VariableScope', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240329205727_ScriptParameters'
)
BEGIN
    DROP INDEX [IX_JobOutput_JobId] ON [JobOutput];
    DECLARE @var19 sysname;
    SELECT @var19 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[JobOutput]') AND [c].[name] = N'JobId');
    IF @var19 IS NOT NULL EXEC(N'ALTER TABLE [JobOutput] DROP CONSTRAINT [' + @var19 + '];');
    EXEC(N'UPDATE [JobOutput] SET [JobId] = CAST(0 AS bigint) WHERE [JobId] IS NULL');
    ALTER TABLE [JobOutput] ALTER COLUMN [JobId] bigint NOT NULL;
    ALTER TABLE [JobOutput] ADD DEFAULT CAST(0 AS bigint) FOR [JobId];
    CREATE INDEX [IX_JobOutput_JobId] ON [JobOutput] ([JobId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240329205727_ScriptParameters'
)
BEGIN
    CREATE TABLE [ScriptParameter] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [DisplayName] nvarchar(max) NULL,
        [Type] nvarchar(max) NULL,
        [ScriptId] bigint NULL,
        [DefaultValue] nvarchar(max) NULL,
        [Required] bit NOT NULL,
        [DisplayType] int NOT NULL,
        [ValidValues] nvarchar(max) NULL,
        [HelpText] nvarchar(max) NULL,
        [ParameterSet] nvarchar(max) NULL,
        [ResolvedDefaultValue] nvarchar(max) NULL,
        [IValidateSetValuesGenerator] nvarchar(max) NULL,
        [Using] nvarchar(max) NULL,
        CONSTRAINT [PK_ScriptParameter] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_ScriptParameter_Scripts_ScriptId] FOREIGN KEY ([ScriptId]) REFERENCES [Scripts] ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240329205727_ScriptParameters'
)
BEGIN
    CREATE INDEX [IX_ScriptParameter_ScriptId] ON [ScriptParameter] ([ScriptId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240329205727_ScriptParameters'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240329205727_ScriptParameters', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240330220911_FolderParent'
)
BEGIN
    ALTER TABLE [Folders] ADD [ParentId] bigint NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240330220911_FolderParent'
)
BEGIN
    CREATE INDEX [IX_Folders_ParentId] ON [Folders] ([ParentId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240330220911_FolderParent'
)
BEGIN
    ALTER TABLE [Folders] ADD CONSTRAINT [FK_Folders_Folders_ParentId] FOREIGN KEY ([ParentId]) REFERENCES [Folders] ([Id]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240330220911_FolderParent'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240330220911_FolderParent', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240401151504_FolderName'
)
BEGIN
    ALTER TABLE [Folders] ADD [Name] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240401151504_FolderName'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240401151504_FolderName', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240401162003_ScriptFolders'
)
BEGIN
    DECLARE @var20 sysname;
    SELECT @var20 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Scripts]') AND [c].[name] = N'Folder');
    IF @var20 IS NOT NULL EXEC(N'ALTER TABLE [Scripts] DROP CONSTRAINT [' + @var20 + '];');
    ALTER TABLE [Scripts] DROP COLUMN [Folder];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240401162003_ScriptFolders'
)
BEGIN
    ALTER TABLE [Scripts] ADD [FolderId] bigint NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240401162003_ScriptFolders'
)
BEGIN
    CREATE INDEX [IX_Scripts_FolderId] ON [Scripts] ([FolderId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240401162003_ScriptFolders'
)
BEGIN
    ALTER TABLE [Scripts] ADD CONSTRAINT [FK_Scripts_Folders_FolderId] FOREIGN KEY ([FolderId]) REFERENCES [Folders] ([Id]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240401162003_ScriptFolders'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240401162003_ScriptFolders', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240401175853_FolderIdentity'
)
BEGIN
    ALTER TABLE [Folders] ADD [IdentityId] bigint NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240401175853_FolderIdentity'
)
BEGIN
    CREATE INDEX [IX_Folders_IdentityId] ON [Folders] ([IdentityId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240401175853_FolderIdentity'
)
BEGIN
    ALTER TABLE [Folders] ADD CONSTRAINT [FK_Folders_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240401175853_FolderIdentity'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240401175853_FolderIdentity', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240402171916_ScriptTags'
)
BEGIN
    ALTER TABLE [ScriptParameter] DROP CONSTRAINT [FK_ScriptParameter_Scripts_ScriptId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240402171916_ScriptTags'
)
BEGIN
    DECLARE @var21 sysname;
    SELECT @var21 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Scripts]') AND [c].[name] = N'ResolvedPath');
    IF @var21 IS NOT NULL EXEC(N'ALTER TABLE [Scripts] DROP CONSTRAINT [' + @var21 + '];');
    ALTER TABLE [Scripts] DROP COLUMN [ResolvedPath];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240402171916_ScriptTags'
)
BEGIN
    DROP INDEX [IX_ScriptParameter_ScriptId] ON [ScriptParameter];
    DECLARE @var22 sysname;
    SELECT @var22 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[ScriptParameter]') AND [c].[name] = N'ScriptId');
    IF @var22 IS NOT NULL EXEC(N'ALTER TABLE [ScriptParameter] DROP CONSTRAINT [' + @var22 + '];');
    EXEC(N'UPDATE [ScriptParameter] SET [ScriptId] = CAST(0 AS bigint) WHERE [ScriptId] IS NULL');
    ALTER TABLE [ScriptParameter] ALTER COLUMN [ScriptId] bigint NOT NULL;
    ALTER TABLE [ScriptParameter] ADD DEFAULT CAST(0 AS bigint) FOR [ScriptId];
    CREATE INDEX [IX_ScriptParameter_ScriptId] ON [ScriptParameter] ([ScriptId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240402171916_ScriptTags'
)
BEGIN
    CREATE TABLE [ScriptTag] (
        [ScriptsId] bigint NOT NULL,
        [TagId] bigint NOT NULL,
        CONSTRAINT [PK_ScriptTag] PRIMARY KEY ([ScriptsId], [TagId]),
        CONSTRAINT [FK_ScriptTag_Scripts_ScriptsId] FOREIGN KEY ([ScriptsId]) REFERENCES [Scripts] ([Id]) ON DELETE CASCADE,
        CONSTRAINT [FK_ScriptTag_Tags_TagId] FOREIGN KEY ([TagId]) REFERENCES [Tags] ([Id]) ON DELETE CASCADE
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240402171916_ScriptTags'
)
BEGIN
    CREATE INDEX [IX_ScriptTag_TagId] ON [ScriptTag] ([TagId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240402171916_ScriptTags'
)
BEGIN
    ALTER TABLE [ScriptParameter] ADD CONSTRAINT [FK_ScriptParameter_Scripts_ScriptId] FOREIGN KEY ([ScriptId]) REFERENCES [Scripts] ([Id]) ON DELETE CASCADE;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240402171916_ScriptTags'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240402171916_ScriptTags', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240402201841_VariablesDb'
)
BEGIN
    ALTER TABLE [Variable] ADD [Description] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240402201841_VariablesDb'
)
BEGIN
    ALTER TABLE [Variable] ADD [DisableRunAsSupport] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240402201841_VariablesDb'
)
BEGIN
    ALTER TABLE [Variable] ADD [MissingSecret] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240402201841_VariablesDb'
)
BEGIN
    ALTER TABLE [Variable] ADD [Role] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240402201841_VariablesDb'
)
BEGIN
    ALTER TABLE [Variable] ADD [Vault] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240402201841_VariablesDb'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240402201841_VariablesDb', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240403201216_Modules'
)
BEGIN
    CREATE TABLE [Modules] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Path] nvarchar(max) NULL,
        [Version] nvarchar(max) NULL,
        [Environment] nvarchar(max) NULL,
        [ReadOnly] bit NOT NULL,
        [Content] nvarchar(max) NULL,
        [Source] int NOT NULL,
        [Repository] nvarchar(max) NULL,
        [Prerelease] bit NOT NULL,
        [Extension] bit NOT NULL,
        [Description] nvarchar(max) NULL,
        [Url] nvarchar(max) NULL,
        [ExtensionFeatures] nvarchar(max) NULL,
        [Downloads] bigint NULL,
        [IsLocal] bit NOT NULL,
        [ProjectUri] nvarchar(max) NULL,
        [IconUri] nvarchar(max) NULL,
        [Tags] nvarchar(max) NULL,
        CONSTRAINT [PK_Modules] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240403201216_Modules'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240403201216_Modules', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240403213048_EndpointsTags'
)
BEGIN
    ALTER TABLE [Tags] DROP CONSTRAINT [FK_Tags_Endpoints_EndpointId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240403213048_EndpointsTags'
)
BEGIN
    DROP INDEX [IX_Tags_EndpointId] ON [Tags];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240403213048_EndpointsTags'
)
BEGIN
    DECLARE @var23 sysname;
    SELECT @var23 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Tags]') AND [c].[name] = N'EndpointId');
    IF @var23 IS NOT NULL EXEC(N'ALTER TABLE [Tags] DROP CONSTRAINT [' + @var23 + '];');
    ALTER TABLE [Tags] DROP COLUMN [EndpointId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240403213048_EndpointsTags'
)
BEGIN
    CREATE TABLE [EndpointTag] (
        [EndpointsId] bigint NOT NULL,
        [TagId] bigint NOT NULL,
        CONSTRAINT [PK_EndpointTag] PRIMARY KEY ([EndpointsId], [TagId]),
        CONSTRAINT [FK_EndpointTag_Endpoints_EndpointsId] FOREIGN KEY ([EndpointsId]) REFERENCES [Endpoints] ([Id]) ON DELETE CASCADE,
        CONSTRAINT [FK_EndpointTag_Tags_TagId] FOREIGN KEY ([TagId]) REFERENCES [Tags] ([Id]) ON DELETE CASCADE
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240403213048_EndpointsTags'
)
BEGIN
    CREATE INDEX [IX_EndpointTag_TagId] ON [EndpointTag] ([TagId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240403213048_EndpointsTags'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240403213048_EndpointsTags', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240403221816_DashboardTags'
)
BEGIN
    ALTER TABLE [Tags] DROP CONSTRAINT [FK_Tags_Apps_DashboardId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240403221816_DashboardTags'
)
BEGIN
    DROP INDEX [IX_Tags_DashboardId] ON [Tags];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240403221816_DashboardTags'
)
BEGIN
    DECLARE @var24 sysname;
    SELECT @var24 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Tags]') AND [c].[name] = N'DashboardId');
    IF @var24 IS NOT NULL EXEC(N'ALTER TABLE [Tags] DROP CONSTRAINT [' + @var24 + '];');
    ALTER TABLE [Tags] DROP COLUMN [DashboardId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240403221816_DashboardTags'
)
BEGIN
    CREATE TABLE [DashboardTag] (
        [DashboardsId] bigint NOT NULL,
        [TagId] bigint NOT NULL,
        CONSTRAINT [PK_DashboardTag] PRIMARY KEY ([DashboardsId], [TagId]),
        CONSTRAINT [FK_DashboardTag_Apps_DashboardsId] FOREIGN KEY ([DashboardsId]) REFERENCES [Apps] ([Id]) ON DELETE CASCADE,
        CONSTRAINT [FK_DashboardTag_Tags_TagId] FOREIGN KEY ([TagId]) REFERENCES [Tags] ([Id]) ON DELETE CASCADE
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240403221816_DashboardTags'
)
BEGIN
    CREATE INDEX [IX_DashboardTag_TagId] ON [DashboardTag] ([TagId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240403221816_DashboardTags'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240403221816_DashboardTags', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240404020541_EndpointDoc'
)
BEGIN
    DECLARE @var25 sysname;
    SELECT @var25 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Endpoints]') AND [c].[name] = N'Documentation');
    IF @var25 IS NOT NULL EXEC(N'ALTER TABLE [Endpoints] DROP CONSTRAINT [' + @var25 + '];');
    ALTER TABLE [Endpoints] DROP COLUMN [Documentation];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240404020541_EndpointDoc'
)
BEGIN
    ALTER TABLE [Endpoints] ADD [DocumentationId] bigint NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240404020541_EndpointDoc'
)
BEGIN
    CREATE INDEX [IX_Endpoints_DocumentationId] ON [Endpoints] ([DocumentationId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240404020541_EndpointDoc'
)
BEGIN
    ALTER TABLE [Endpoints] ADD CONSTRAINT [FK_Endpoints_EndpointDocumentation_DocumentationId] FOREIGN KEY ([DocumentationId]) REFERENCES [EndpointDocumentation] ([Id]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240404020541_EndpointDoc'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240404020541_EndpointDoc', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240404131015_VariableTags'
)
BEGIN
    CREATE TABLE [TagVariable] (
        [TagId] bigint NOT NULL,
        [VariablesId] bigint NOT NULL,
        CONSTRAINT [PK_TagVariable] PRIMARY KEY ([TagId], [VariablesId]),
        CONSTRAINT [FK_TagVariable_Tags_TagId] FOREIGN KEY ([TagId]) REFERENCES [Tags] ([Id]) ON DELETE CASCADE,
        CONSTRAINT [FK_TagVariable_Variable_VariablesId] FOREIGN KEY ([VariablesId]) REFERENCES [Variable] ([Id]) ON DELETE CASCADE
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240404131015_VariableTags'
)
BEGIN
    CREATE INDEX [IX_TagVariable_VariablesId] ON [TagVariable] ([VariablesId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240404131015_VariableTags'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240404131015_VariableTags', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240408225651_ModuleUpdates'
)
BEGIN
    ALTER TABLE [Settings] ADD [CheckForModuleUpdates] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240408225651_ModuleUpdates'
)
BEGIN
    ALTER TABLE [Modules] ADD [UpdatedVersion] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240408225651_ModuleUpdates'
)
BEGIN
    ALTER TABLE [Dataitems] ADD [ComputerId] bigint NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240408225651_ModuleUpdates'
)
BEGIN
    ALTER TABLE [Dataitems] ADD [Persistent] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240408225651_ModuleUpdates'
)
BEGIN
    CREATE INDEX [IX_Dataitems_ComputerId] ON [Dataitems] ([ComputerId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240408225651_ModuleUpdates'
)
BEGIN
    ALTER TABLE [Dataitems] ADD CONSTRAINT [FK_Dataitems_Computer_ComputerId] FOREIGN KEY ([ComputerId]) REFERENCES [Computer] ([Id]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240408225651_ModuleUpdates'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240408225651_ModuleUpdates', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240411105923_ScheduleIdentity'
)
BEGIN
    ALTER TABLE [Schedules] DROP CONSTRAINT [FK_Schedules_Identity_IdentityId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240411105923_ScheduleIdentity'
)
BEGIN
    DROP INDEX [IX_Schedules_IdentityId] ON [Schedules];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240411105923_ScheduleIdentity'
)
BEGIN
    DECLARE @var26 sysname;
    SELECT @var26 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Schedules]') AND [c].[name] = N'IdentityId');
    IF @var26 IS NOT NULL EXEC(N'ALTER TABLE [Schedules] DROP CONSTRAINT [' + @var26 + '];');
    ALTER TABLE [Schedules] DROP COLUMN [IdentityId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240411105923_ScheduleIdentity'
)
BEGIN
    ALTER TABLE [Schedules] ADD [Identity] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240411105923_ScheduleIdentity'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240411105923_ScheduleIdentity', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240423203126_SecurityContext'
)
BEGIN
    ALTER TABLE [Job] ADD [SecurityContextId] uniqueidentifier NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240423203126_SecurityContext'
)
BEGIN
    CREATE TABLE [Permissions] (
        [Id] bigint NOT NULL IDENTITY,
        [Role] nvarchar(max) NULL,
        [IdentityId] bigint NULL,
        [Identifier] nvarchar(max) NULL,
        [Scope] int NOT NULL,
        [Resource] nvarchar(max) NULL,
        CONSTRAINT [PK_Permissions] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_Permissions_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240423203126_SecurityContext'
)
BEGIN
    CREATE INDEX [IX_Permissions_IdentityId] ON [Permissions] ([IdentityId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240423203126_SecurityContext'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240423203126_SecurityContext', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240424210600_CustomHealthChecks'
)
BEGIN
    CREATE TABLE [CustomHealthChecks] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [DisableUnix] bit NOT NULL,
        [DisableWindows] bit NOT NULL,
        [ScriptBlock] nvarchar(max) NULL,
        [Disabled] bit NOT NULL,
        [BuiltIn] bit NOT NULL,
        CONSTRAINT [PK_CustomHealthChecks] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240424210600_CustomHealthChecks'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240424210600_CustomHealthChecks', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240425211522_ModuleManifest'
)
BEGIN
    ALTER TABLE [Modules] ADD [ManifestContent] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240425211522_ModuleManifest'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240425211522_ModuleManifest', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240427013019_BreakpointsUpdate'
)
BEGIN
    DECLARE @var27 sysname;
    SELECT @var27 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[ExecutionEnvironments]') AND [c].[name] = N'EnableDebugger');
    IF @var27 IS NOT NULL EXEC(N'ALTER TABLE [ExecutionEnvironments] DROP CONSTRAINT [' + @var27 + '];');
    ALTER TABLE [ExecutionEnvironments] DROP COLUMN [EnableDebugger];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240427013019_BreakpointsUpdate'
)
BEGIN
    CREATE TABLE [Breakpoints] (
        [Id] bigint NOT NULL IDENTITY,
        [ProcessId] int NOT NULL,
        [RunspaceId] int NOT NULL,
        [Computer] nvarchar(max) NULL,
        [DebugActionType] int NOT NULL,
        [Command] nvarchar(max) NULL,
        [Output] nvarchar(max) NULL,
        CONSTRAINT [PK_Breakpoints] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240427013019_BreakpointsUpdate'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240427013019_BreakpointsUpdate', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240501131354_LastChecked'
)
BEGIN
    ALTER TABLE [Modules] ADD [LastUpdateCheck] datetime2 NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240501131354_LastChecked'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240501131354_LastChecked', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240503093634_DeleteAccessControls'
)
BEGIN
    DECLARE @var28 sysname;
    SELECT @var28 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Scripts]') AND [c].[name] = N'AccessControls');
    IF @var28 IS NOT NULL EXEC(N'ALTER TABLE [Scripts] DROP CONSTRAINT [' + @var28 + '];');
    ALTER TABLE [Scripts] DROP COLUMN [AccessControls];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240503093634_DeleteAccessControls'
)
BEGIN
    DECLARE @var29 sysname;
    SELECT @var29 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Scripts]') AND [c].[name] = N'Anonymous');
    IF @var29 IS NOT NULL EXEC(N'ALTER TABLE [Scripts] DROP CONSTRAINT [' + @var29 + '];');
    ALTER TABLE [Scripts] DROP COLUMN [Anonymous];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240503093634_DeleteAccessControls'
)
BEGIN
    DECLARE @var30 sysname;
    SELECT @var30 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Apps]') AND [c].[name] = N'AccessControls');
    IF @var30 IS NOT NULL EXEC(N'ALTER TABLE [Apps] DROP CONSTRAINT [' + @var30 + '];');
    ALTER TABLE [Apps] DROP COLUMN [AccessControls];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240503093634_DeleteAccessControls'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240503093634_DeleteAccessControls', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240508202614_StackTrace'
)
BEGIN
    ALTER TABLE [Notification] ADD [StackTrace] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240508202614_StackTrace'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240508202614_StackTrace', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240509142403_HideRunLater'
)
BEGIN
    ALTER TABLE [Settings] ADD [HideRunLater] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240509142403_HideRunLater'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240509142403_HideRunLater', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240514085141_Anon'
)
BEGIN
    ALTER TABLE [Settings] ADD [AnonymousApiDocumentation] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240514085141_Anon'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240514085141_Anon', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240515180029_IdentityTheme'
)
BEGIN
    ALTER TABLE [Identity] ADD [Theme] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240515180029_IdentityTheme'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240515180029_IdentityTheme', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240516191344_PortalTitle'
)
BEGIN
    ALTER TABLE [Branding] ADD [PortalTitle] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240516191344_PortalTitle'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240516191344_PortalTitle', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240520153652_PortalOutputType'
)
BEGIN
    ALTER TABLE [Scripts] ADD [PortalOutputType] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240520153652_PortalOutputType'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240520153652_PortalOutputType', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240601182727_BranchFilter'
)
BEGIN
    ALTER TABLE [Scripts] ADD [AvailableInBranch] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240601182727_BranchFilter'
)
BEGIN
    ALTER TABLE [Endpoints] ADD [AvailableInBranch] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240601182727_BranchFilter'
)
BEGIN
    ALTER TABLE [BlazorPages] ADD [AvailableInBranch] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240601182727_BranchFilter'
)
BEGIN
    ALTER TABLE [Apps] ADD [AvailableInBranch] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240601182727_BranchFilter'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240601182727_BranchFilter', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240601190336_ScheduleBranches'
)
BEGIN
    ALTER TABLE [Schedules] ADD [AvailableInBranch] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240601190336_ScheduleBranches'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240601190336_ScheduleBranches', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240607193751_TagPortal'
)
BEGIN
    ALTER TABLE [Tags] ADD [DisplayInPortal] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240607193751_TagPortal'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240607193751_TagPortal', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240607200406_TagRole'
)
BEGIN
    ALTER TABLE [Tags] ADD [Role] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240607200406_TagRole'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240607200406_TagRole', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240608210706_JobTableSettings'
)
BEGIN
    ALTER TABLE [Identity] ADD [JobTabColumns] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240608210706_JobTableSettings'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240608210706_JobTableSettings', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240608230442_JobStatuses'
)
BEGIN
    EXEC sp_rename N'[Identity].[JobTabColumns]', N'JobStatuses', 'COLUMN';
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240608230442_JobStatuses'
)
BEGIN
    ALTER TABLE [Identity] ADD [JobColumns] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240608230442_JobStatuses'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240608230442_JobStatuses', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240617205525_VariableModule'
)
BEGIN
    ALTER TABLE [Variable] ADD [Module] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240617205525_VariableModule'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240617205525_VariableModule', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240617210304_RequiredVariable'
)
BEGIN
    ALTER TABLE [Variable] ADD [Required] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240617210304_RequiredVariable'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240617210304_RequiredVariable', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240618190231_EmbedInPortal'
)
BEGIN
    ALTER TABLE [BlazorPages] ADD [EmbedInPortal] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240618190231_EmbedInPortal'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240618190231_EmbedInPortal', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240702121706_PortalPages'
)
BEGIN
    DROP TABLE [BlazorPages];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240702121706_PortalPages'
)
BEGIN
    DROP TABLE [CustomBlazorComponents];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240702121706_PortalPages'
)
BEGIN
    ALTER TABLE [Tags] ADD [PortalPageId] bigint NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240702121706_PortalPages'
)
BEGIN
    CREATE TABLE [PortalComponents] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [RazorContent] nvarchar(max) NULL,
        [PowerShellContent] nvarchar(max) NULL,
        [RazorPath] nvarchar(max) NULL,
        [PowerShellPath] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [ReadOnly] bit NOT NULL,
        [Title] nvarchar(max) NULL,
        [AvailableInBranch] nvarchar(max) NULL,
        [Height] int NOT NULL,
        [Width] int NOT NULL,
        CONSTRAINT [PK_PortalComponents] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240702121706_PortalPages'
)
BEGIN
    CREATE TABLE [PortalPages] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [Authenticated] bit NOT NULL,
        [Role] nvarchar(max) NULL,
        [AvailableInBranch] nvarchar(max) NULL,
        CONSTRAINT [PK_PortalPages] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240702121706_PortalPages'
)
BEGIN
    CREATE TABLE [PortalComponentInstance] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Width] int NOT NULL,
        [ModulePath] nvarchar(max) NULL,
        [PortalPageId] bigint NULL,
        CONSTRAINT [PK_PortalComponentInstance] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_PortalComponentInstance_PortalPages_PortalPageId] FOREIGN KEY ([PortalPageId]) REFERENCES [PortalPages] ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240702121706_PortalPages'
)
BEGIN
    CREATE TABLE [PortalComponentProperty] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [Type] nvarchar(max) NULL,
        [DefaultValue] nvarchar(max) NULL,
        [Required] bit NOT NULL,
        [Value] nvarchar(max) NULL,
        [PortalComponentInstanceId] bigint NULL,
        [PortalComponentId] bigint NULL,
        CONSTRAINT [PK_PortalComponentProperty] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_PortalComponentProperty_PortalComponentInstance_PortalComponentInstanceId] FOREIGN KEY ([PortalComponentInstanceId]) REFERENCES [PortalComponentInstance] ([Id]),
        CONSTRAINT [FK_PortalComponentProperty_PortalComponents_PortalComponentId] FOREIGN KEY ([PortalComponentId]) REFERENCES [PortalComponents] ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240702121706_PortalPages'
)
BEGIN
    CREATE INDEX [IX_Tags_PortalPageId] ON [Tags] ([PortalPageId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240702121706_PortalPages'
)
BEGIN
    CREATE INDEX [IX_PortalComponentInstance_PortalPageId] ON [PortalComponentInstance] ([PortalPageId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240702121706_PortalPages'
)
BEGIN
    CREATE INDEX [IX_PortalComponentProperty_PortalComponentId] ON [PortalComponentProperty] ([PortalComponentId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240702121706_PortalPages'
)
BEGIN
    CREATE INDEX [IX_PortalComponentProperty_PortalComponentInstanceId] ON [PortalComponentProperty] ([PortalComponentInstanceId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240702121706_PortalPages'
)
BEGIN
    ALTER TABLE [Tags] ADD CONSTRAINT [FK_Tags_PortalPages_PortalPageId] FOREIGN KEY ([PortalPageId]) REFERENCES [PortalPages] ([Id]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240702121706_PortalPages'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240702121706_PortalPages', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240707124843_RoleBuiltIn'
)
BEGIN
    ALTER TABLE [Roles] ADD [BuiltIn] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240707124843_RoleBuiltIn'
)
BEGIN
    ALTER TABLE [PortalComponentInstance] ADD [Height] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240707124843_RoleBuiltIn'
)
BEGIN
    ALTER TABLE [Permissions] ADD [BuiltIn] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240707124843_RoleBuiltIn'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240707124843_RoleBuiltIn', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240707142748_PasswordLastSet'
)
BEGIN
    ALTER TABLE [Identity] ADD [PasswordLastSet] datetime2 NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240707142748_PasswordLastSet'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240707142748_PasswordLastSet', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712132031_ModuleName'
)
BEGIN
    ALTER TABLE [Triggers] ADD [Module] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712132031_ModuleName'
)
BEGIN
    ALTER TABLE [Terminals] ADD [Module] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712132031_ModuleName'
)
BEGIN
    ALTER TABLE [Tags] ADD [Module] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712132031_ModuleName'
)
BEGIN
    ALTER TABLE [Settings] ADD [Module] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712132031_ModuleName'
)
BEGIN
    DECLARE @var31 sysname;
    SELECT @var31 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Scripts]') AND [c].[name] = N'Name');
    IF @var31 IS NOT NULL EXEC(N'ALTER TABLE [Scripts] DROP CONSTRAINT [' + @var31 + '];');
    ALTER TABLE [Scripts] ALTER COLUMN [Name] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712132031_ModuleName'
)
BEGIN
    ALTER TABLE [Schedules] ADD [Module] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712132031_ModuleName'
)
BEGIN
    ALTER TABLE [Roles] ADD [Module] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712132031_ModuleName'
)
BEGIN
    ALTER TABLE [PublishedFolders] ADD [Module] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712132031_ModuleName'
)
BEGIN
    ALTER TABLE [PortalComponents] ADD [Module] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712132031_ModuleName'
)
BEGIN
    ALTER TABLE [Licenses] ADD [Module] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712132031_ModuleName'
)
BEGIN
    ALTER TABLE [ExecutionEnvironments] ADD [Module] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712132031_ModuleName'
)
BEGIN
    ALTER TABLE [EndpointDocumentation] ADD [Module] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712132031_ModuleName'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240712132031_ModuleName', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712170122_Positioning'
)
BEGIN
    ALTER TABLE [PortalComponentInstance] ADD [Column] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712170122_Positioning'
)
BEGIN
    ALTER TABLE [PortalComponentInstance] ADD [Offset] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712170122_Positioning'
)
BEGIN
    ALTER TABLE [PortalComponentInstance] ADD [Row] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240712170122_Positioning'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240712170122_Positioning', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240719130241_JobActionPreferences'
)
BEGIN
    DECLARE @var32 sysname;
    SELECT @var32 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Job]') AND [c].[name] = N'ErrorAction');
    IF @var32 IS NOT NULL EXEC(N'ALTER TABLE [Job] DROP CONSTRAINT [' + @var32 + '];');
    ALTER TABLE [Job] DROP COLUMN [ErrorAction];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240719130241_JobActionPreferences'
)
BEGIN
    ALTER TABLE [Job] ADD [DebugPreference] int NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240719130241_JobActionPreferences'
)
BEGIN
    ALTER TABLE [Job] ADD [ErrorPreference] int NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240719130241_JobActionPreferences'
)
BEGIN
    ALTER TABLE [Job] ADD [InformationPreference] int NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240719130241_JobActionPreferences'
)
BEGIN
    ALTER TABLE [Job] ADD [ProgressPreference] int NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240719130241_JobActionPreferences'
)
BEGIN
    ALTER TABLE [Job] ADD [VerbosePreference] int NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240719130241_JobActionPreferences'
)
BEGIN
    ALTER TABLE [Job] ADD [WarningPreference] int NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240719130241_JobActionPreferences'
)
BEGIN
    ALTER TABLE [Dataitems] ADD [Roles] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240719130241_JobActionPreferences'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240719130241_JobActionPreferences', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240725154007_AppTokenLifespan'
)
BEGIN
    ALTER TABLE [Settings] ADD [MaximumTokenLifetime] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240725154007_AppTokenLifespan'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240725154007_AppTokenLifespan', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240728125906_RolePermissions'
)
BEGIN
    DECLARE @var33 sysname;
    SELECT @var33 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Permissions]') AND [c].[name] = N'Role');
    IF @var33 IS NOT NULL EXEC(N'ALTER TABLE [Permissions] DROP CONSTRAINT [' + @var33 + '];');
    ALTER TABLE [Permissions] DROP COLUMN [Role];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240728125906_RolePermissions'
)
BEGIN
    ALTER TABLE [Roles] ADD [Permissions] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240728125906_RolePermissions'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240728125906_RolePermissions', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240804131608_ParameterSets'
)
BEGIN
    ALTER TABLE [Scripts] ADD [ParameterSets] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240804131608_ParameterSets'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240804131608_ParameterSets', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240809150646_DataProtection'
)
BEGIN
    CREATE TABLE [DataProtectionKeys] (
        [Id] int NOT NULL IDENTITY,
        [FriendlyName] nvarchar(max) NULL,
        [Xml] nvarchar(max) NULL,
        CONSTRAINT [PK_DataProtectionKeys] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240809150646_DataProtection'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240809150646_DataProtection', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240913201400_5.0.7'
)
BEGIN
    CREATE INDEX [IX_JobOutput_Timestamp] ON [JobOutput] ([Timestamp]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240913201400_5.0.7'
)
BEGIN
    CREATE INDEX [IX_JobOutput_Type] ON [JobOutput] ([Type]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240913201400_5.0.7'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240913201400_5.0.7', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240930073736_5.0.9'
)
BEGIN
    DECLARE @var34 sysname;
    SELECT @var34 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Identity]') AND [c].[name] = N'Name');
    IF @var34 IS NOT NULL EXEC(N'ALTER TABLE [Identity] DROP CONSTRAINT [' + @var34 + '];');
    ALTER TABLE [Identity] ALTER COLUMN [Name] nvarchar(max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240930073736_5.0.9'
)
BEGIN
    CREATE TABLE [DashboardPage] (
        [Id] bigint NOT NULL IDENTITY,
        [Url] nvarchar(max) NULL,
        [Name] nvarchar(max) NULL,
        [Role] nvarchar(max) NULL,
        [PageContent] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [DefaultHomePage] bit NOT NULL,
        [Title] nvarchar(max) NULL,
        [Blank] bit NOT NULL,
        [Loading] nvarchar(max) NULL,
        [NavLayout] nvarchar(max) NULL,
        [Logo] nvarchar(max) NULL,
        [HeaderPosition] nvarchar(max) NULL,
        [HeaderColor] nvarchar(max) NULL,
        [HeaderBackgroundColor] nvarchar(max) NULL,
        [HideUserName] bit NOT NULL,
        [HideNavigation] bit NOT NULL,
        [ComponentId] nvarchar(max) NULL,
        [DashboardId] bigint NOT NULL,
        [Static] bit NOT NULL,
        [BackgroundImage] nvarchar(max) NULL,
        [BackgroundRepeat] bit NOT NULL,
        [FileName] nvarchar(max) NULL,
        [Template] nvarchar(max) NULL,
        CONSTRAINT [PK_DashboardPage] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_DashboardPage_Apps_DashboardId] FOREIGN KEY ([DashboardId]) REFERENCES [Apps] ([Id]) ON DELETE CASCADE
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240930073736_5.0.9'
)
BEGIN
    CREATE INDEX [IX_DashboardPage_DashboardId] ON [DashboardPage] ([DashboardId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20240930073736_5.0.9'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20240930073736_5.0.9', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241001200155_5.0.10'
)
BEGIN
    DROP INDEX [IX_Job_ScriptFullPath] ON [Job];
    DECLARE @var35 sysname;
    SELECT @var35 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Job]') AND [c].[name] = N'ScriptFullPath');
    IF @var35 IS NOT NULL EXEC(N'ALTER TABLE [Job] DROP CONSTRAINT [' + @var35 + '];');
    ALTER TABLE [Job] ALTER COLUMN [ScriptFullPath] nvarchar(450) COLLATE SQL_Latin1_General_CP1_CI_AS NULL;
    CREATE INDEX [IX_Job_ScriptFullPath] ON [Job] ([ScriptFullPath]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241001200155_5.0.10'
)
BEGIN
    DECLARE @var36 sysname;
    SELECT @var36 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Job]') AND [c].[name] = N'Environment');
    IF @var36 IS NOT NULL EXEC(N'ALTER TABLE [Job] DROP CONSTRAINT [' + @var36 + '];');
    ALTER TABLE [Job] ALTER COLUMN [Environment] nvarchar(max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241001200155_5.0.10'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20241001200155_5.0.10', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241006150517_5.0.10.1'
)
BEGIN
    ALTER TABLE [Tags] DROP CONSTRAINT [FK_Tags_PortalPages_PortalPageId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241006150517_5.0.10.1'
)
BEGIN
    DROP TABLE [DashboardTag];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241006150517_5.0.10.1'
)
BEGIN
    DROP TABLE [EndpointTag];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241006150517_5.0.10.1'
)
BEGIN
    DROP TABLE [ScriptTag];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241006150517_5.0.10.1'
)
BEGIN
    DROP TABLE [TagVariable];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241006150517_5.0.10.1'
)
BEGIN
    DROP INDEX [IX_Tags_PortalPageId] ON [Tags];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241006150517_5.0.10.1'
)
BEGIN
    DECLARE @var37 sysname;
    SELECT @var37 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Tags]') AND [c].[name] = N'PortalPageId');
    IF @var37 IS NOT NULL EXEC(N'ALTER TABLE [Tags] DROP CONSTRAINT [' + @var37 + '];');
    ALTER TABLE [Tags] DROP COLUMN [PortalPageId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241006150517_5.0.10.1'
)
BEGIN
    ALTER TABLE [Variable] ADD [Tags] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241006150517_5.0.10.1'
)
BEGIN
    ALTER TABLE [Scripts] ADD [Tags] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241006150517_5.0.10.1'
)
BEGIN
    ALTER TABLE [PortalPages] ADD [Tags] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241006150517_5.0.10.1'
)
BEGIN
    ALTER TABLE [Endpoints] ADD [Tags] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241006150517_5.0.10.1'
)
BEGIN
    ALTER TABLE [Apps] ADD [Tags] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241006150517_5.0.10.1'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20241006150517_5.0.10.1', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241017175322_5.0.12'
)
BEGIN
    DROP INDEX [IX_JobPipelineOutput_JobId] ON [JobPipelineOutput];
    DECLARE @var38 sysname;
    SELECT @var38 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[JobPipelineOutput]') AND [c].[name] = N'JobId');
    IF @var38 IS NOT NULL EXEC(N'ALTER TABLE [JobPipelineOutput] DROP CONSTRAINT [' + @var38 + '];');
    EXEC(N'UPDATE [JobPipelineOutput] SET [JobId] = CAST(0 AS bigint) WHERE [JobId] IS NULL');
    ALTER TABLE [JobPipelineOutput] ALTER COLUMN [JobId] bigint NOT NULL;
    ALTER TABLE [JobPipelineOutput] ADD DEFAULT CAST(0 AS bigint) FOR [JobId];
    CREATE INDEX [IX_JobPipelineOutput_JobId] ON [JobPipelineOutput] ([JobId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241017175322_5.0.12'
)
BEGIN
    ALTER TABLE [DashboardPage] ADD [IconName] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241017175322_5.0.12'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20241017175322_5.0.12', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241021171905_5.0.13'
)
BEGIN
    ALTER TABLE [Breakpoints] ADD [Identifier] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241021171905_5.0.13'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20241021171905_5.0.13', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241101144221_5.0.15'
)
BEGIN
    ALTER TABLE [EventHubConnections] ADD [RemoteDomainName] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241101144221_5.0.15'
)
BEGIN
    ALTER TABLE [EventHubConnections] ADD [RemoteUserName] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241101144221_5.0.15'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20241101144221_5.0.15', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241111144226_5.0.16'
)
BEGIN
    ALTER TABLE [Settings] ADD [PortalDisabled] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241111144226_5.0.16'
)
BEGIN
    ALTER TABLE [Settings] ADD [PortalRole] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241111144226_5.0.16'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20241111144226_5.0.16', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241112172531_5.0.16.1'
)
BEGIN
    ALTER TABLE [Licenses] ADD [Online] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241112172531_5.0.16.1'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20241112172531_5.0.16.1', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [Job] DROP CONSTRAINT [FK_Job_Identity_IdentityId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [Roles] DROP CONSTRAINT [FK_Roles_Roles_RoleId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    DROP INDEX [IX_Roles_RoleId] ON [Roles];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    DECLARE @var39 sysname;
    SELECT @var39 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Roles]') AND [c].[name] = N'RoleId');
    IF @var39 IS NOT NULL EXEC(N'ALTER TABLE [Roles] DROP CONSTRAINT [' + @var39 + '];');
    ALTER TABLE [Roles] DROP COLUMN [RoleId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [Settings] ADD [DefaultTokenLifetime] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [Roles] ADD [ChildRoles] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [EndpointDocumentation] ADD [ContactEmail] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [EndpointDocumentation] ADD [ContactName] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [EndpointDocumentation] ADD [ContactUrl] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [EndpointDocumentation] ADD [LicenseName] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [EndpointDocumentation] ADD [LicenseUrl] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [EndpointDocumentation] ADD [TermsOfServiceUrl] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [EndpointDocumentation] ADD [Version] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [Computer] ADD [DeploymentName] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [Computer] ADD [DeploymentVersion] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [Branding] ADD [DarkAppBarLogo] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    CREATE TABLE [Deployments] (
        [Id] bigint NOT NULL IDENTITY,
        [Version] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [Date] datetime2 NOT NULL,
        [Storage] int NOT NULL,
        [Pinned] bit NOT NULL,
        [Name] nvarchar(max) NULL,
        [Repository] nvarchar(max) NULL,
        CONSTRAINT [PK_Deployments] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    CREATE TABLE [DeploymentContent] (
        [Id] bigint NOT NULL IDENTITY,
        [Content] varbinary(max) NULL,
        [DeploymentId] bigint NOT NULL,
        CONSTRAINT [PK_DeploymentContent] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_DeploymentContent_Deployments_DeploymentId] FOREIGN KEY ([DeploymentId]) REFERENCES [Deployments] ([Id]) ON DELETE CASCADE
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    CREATE INDEX [IX_DeploymentContent_DeploymentId] ON [DeploymentContent] ([DeploymentId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    ALTER TABLE [Job] ADD CONSTRAINT [FK_Job_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id]) ON DELETE SET NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20241127203525_5.1.0'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20241127203525_5.1.0', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    EXEC sp_rename N'[Modules].[ExtensionFeatures]', N'Dependencies', 'COLUMN';
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    ALTER TABLE [Settings] ADD [ApiSecurityModel] int NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    ALTER TABLE [Settings] ADD [DefaultRunOn] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    ALTER TABLE [Scripts] ADD [FolderPath] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    ALTER TABLE [Scripts] ADD [ReadPermission] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    ALTER TABLE [Scripts] ADD [Resource] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    ALTER TABLE [Modules] ADD [Licensed] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    ALTER TABLE [Modules] ADD [Loaded] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    ALTER TABLE [Licenses] ADD [ComputerName] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    ALTER TABLE [Job] ADD [ReadPermission] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    ALTER TABLE [Job] ADD [Resource] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    ALTER TABLE [GitSettings] ADD [Name] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    ALTER TABLE [Computer] ADD [GitBranch] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    ALTER TABLE [Computer] ADD [GitSettings] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    ALTER TABLE [Branding] ADD [LoginPageTheme] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    CREATE TABLE [SystemSettings] (
        [Id] bigint NOT NULL IDENTITY,
        [AccountLicenseKey] nvarchar(max) NULL,
        CONSTRAINT [PK_SystemSettings] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250109185743_5.2.0'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20250109185743_5.2.0', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    ALTER TABLE [Schedules] ADD [Day] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    ALTER TABLE [Schedules] ADD [DayOfMonth] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    ALTER TABLE [Schedules] ADD [DayOfWeek] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    ALTER TABLE [Schedules] ADD [EveryDay] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    ALTER TABLE [Schedules] ADD [EveryHour] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    ALTER TABLE [Schedules] ADD [EveryMonth] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    ALTER TABLE [Schedules] ADD [Hour] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    ALTER TABLE [Schedules] ADD [Minute] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    ALTER TABLE [Schedules] ADD [Month] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    ALTER TABLE [Schedules] ADD [SpecificMonth] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    ALTER TABLE [Identity] ADD [System] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    ALTER TABLE [ExecutionEnvironments] ADD [Verb] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    ALTER TABLE [Endpoints] ADD [Credential] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    ALTER TABLE [AuthenticationMethods] ADD [NameIdPolicy] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    CREATE TABLE [ChildProcessAssemblies] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Version] nvarchar(max) NULL,
        [Path] nvarchar(max) NULL,
        [ProcessId] bigint NOT NULL,
        CONSTRAINT [PK_ChildProcessAssemblies] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    CREATE TABLE [ChildProcesses] (
        [Id] bigint NOT NULL IDENTITY,
        [ProcessId] int NOT NULL,
        [ProcessName] nvarchar(max) NULL,
        [ProcessArgs] nvarchar(max) NULL,
        [ProcessUser] nvarchar(max) NULL,
        [Memory] bigint NOT NULL,
        [Cpu] int NOT NULL,
        [Description] nvarchar(max) NULL,
        [Environment] nvarchar(max) NULL,
        [Type] int NOT NULL,
        [VirtualMemory] bigint NOT NULL,
        [Computer] nvarchar(max) NULL,
        [StartTime] datetime2 NOT NULL,
        CONSTRAINT [PK_ChildProcesses] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    CREATE TABLE [ChildRunspaces] (
        [Id] bigint NOT NULL IDENTITY,
        [RunspaceId] bigint NOT NULL,
        [Availability] nvarchar(max) NULL,
        [State] nvarchar(max) NULL,
        [ProcessId] bigint NOT NULL,
        CONSTRAINT [PK_ChildRunspaces] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    CREATE TABLE [RateLimitRules] (
        [Id] bigint NOT NULL IDENTITY,
        [Endpoint] nvarchar(max) NULL,
        [Period] time NOT NULL,
        [Limit] int NOT NULL,
        [ReadOnly] bit NOT NULL,
        [Module] nvarchar(max) NULL,
        [Name] nvarchar(max) NULL,
        CONSTRAINT [PK_RateLimitRules] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    CREATE TABLE [TestFiles] (
        [Id] bigint NOT NULL IDENTITY,
        [Path] nvarchar(max) NULL,
        CONSTRAINT [PK_TestFiles] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    CREATE TABLE [TestRuns] (
        [Id] bigint NOT NULL IDENTITY,
        [StartTime] datetime2 NOT NULL,
        [EndTime] datetime2 NOT NULL,
        [Status] int NOT NULL,
        [Total] int NOT NULL,
        [ErrorCount] int NOT NULL,
        [FailureCount] int NOT NULL,
        [SkippedCount] int NOT NULL,
        [IgnoredCount] int NOT NULL,
        [NotRunCount] int NOT NULL,
        [InvalidCount] int NOT NULL,
        [TestSuiteId] bigint NULL,
        [Computer] nvarchar(max) NULL,
        [Environment] nvarchar(max) NULL,
        [Credential] nvarchar(max) NULL,
        [Path] nvarchar(max) NULL,
        [Error] nvarchar(max) NULL,
        [TagFilter] nvarchar(max) NULL,
        [ExcludeTagFilter] nvarchar(max) NULL,
        [FullNameFilter] nvarchar(max) NULL,
        CONSTRAINT [PK_TestRuns] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    CREATE TABLE [TestSuites] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Type] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [Executed] bit NOT NULL,
        [Result] nvarchar(max) NULL,
        [Success] bit NOT NULL,
        [Time] time NOT NULL,
        [Asserts] int NOT NULL,
        [ParentSuiteId] bigint NULL,
        [TestRunId] bigint NULL,
        CONSTRAINT [PK_TestSuites] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_TestSuites_TestSuites_ParentSuiteId] FOREIGN KEY ([ParentSuiteId]) REFERENCES [TestSuites] ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    CREATE TABLE [TestCases] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [Description] nvarchar(max) NULL,
        [Time] time NOT NULL,
        [Asserts] int NOT NULL,
        [Success] bit NOT NULL,
        [Result] nvarchar(max) NULL,
        [Executed] bit NOT NULL,
        [FailureMessage] nvarchar(max) NULL,
        [FailureStackTrace] nvarchar(max) NULL,
        [TestSuiteId] bigint NULL,
        CONSTRAINT [PK_TestCases] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_TestCases_TestSuites_TestSuiteId] FOREIGN KEY ([TestSuiteId]) REFERENCES [TestSuites] ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    CREATE INDEX [IX_TestCases_TestSuiteId] ON [TestCases] ([TestSuiteId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    CREATE INDEX [IX_TestSuites_ParentSuiteId] ON [TestSuites] ([ParentSuiteId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250206134544_5.3.0'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20250206134544_5.3.0', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [JobFeedback] DROP CONSTRAINT [FK_JobFeedback_Identity_IdentityId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [LogExports] DROP CONSTRAINT [FK_LogExports_Identity_IdentityId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [Notification] DROP CONSTRAINT [FK_Notification_Identity_IdentityId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [TerminalInstance] DROP CONSTRAINT [FK_TerminalInstance_Identity_IdentityId];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    DROP TABLE [DbVersion];
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [Variable] ADD [PasswordNotRequired] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [Settings] ADD [DisableFirstRun] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [Scripts] ADD [PortalOpenInNewWindow] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [Roles] ADD [Priority] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [ExecutionEnvironments] ADD [Type] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [Endpoints] ADD [Disabled] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [Computer] ADD [Type] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    CREATE TABLE [EndpointTestRequests] (
        [Id] bigint NOT NULL IDENTITY,
        [Url] nvarchar(max) NULL,
        [Method] nvarchar(max) NULL,
        [QueryStringParameter] nvarchar(max) NULL,
        [Header] nvarchar(max) NULL,
        [Body] nvarchar(max) NULL,
        [ContentType] nvarchar(max) NULL,
        [User] nvarchar(max) NULL,
        [Roles] nvarchar(max) NULL,
        [Authenticate] bit NOT NULL,
        [IdentityId] bigint NULL,
        CONSTRAINT [PK_EndpointTestRequests] PRIMARY KEY ([Id]),
        CONSTRAINT [FK_EndpointTestRequests_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id]) ON DELETE CASCADE
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    CREATE TABLE [JobQueues] (
        [Id] bigint NOT NULL IDENTITY,
        [Script] nvarchar(max) NULL,
        [Schedule] nvarchar(450) NULL,
        [Computer] nvarchar(max) NULL,
        [Dispatcher] nvarchar(max) NULL,
        [TimeStamp] datetime2 NOT NULL,
        [Description] nvarchar(max) NULL,
        [JobId] bigint NULL,
        [CorrelationId] uniqueidentifier NOT NULL,
        CONSTRAINT [PK_JobQueues] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    CREATE INDEX [IX_EndpointTestRequests_IdentityId] ON [EndpointTestRequests] ([IdentityId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    CREATE INDEX [IX_JobQueues_CorrelationId] ON [JobQueues] ([CorrelationId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    CREATE INDEX [IX_JobQueues_JobId] ON [JobQueues] ([JobId]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    CREATE INDEX [IX_JobQueues_Schedule] ON [JobQueues] ([Schedule]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [JobFeedback] ADD CONSTRAINT [FK_JobFeedback_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id]) ON DELETE CASCADE;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [LogExports] ADD CONSTRAINT [FK_LogExports_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id]) ON DELETE CASCADE;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [Notification] ADD CONSTRAINT [FK_Notification_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id]) ON DELETE CASCADE;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    ALTER TABLE [TerminalInstance] ADD CONSTRAINT [FK_TerminalInstance_Identity_IdentityId] FOREIGN KEY ([IdentityId]) REFERENCES [Identity] ([Id]) ON DELETE CASCADE;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250304215443_5.4'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20250304215443_5.4', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [Tags] ADD [Icon] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [Settings] ADD [DebugPreference] int NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [Settings] ADD [ErrorPreference] int NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [Settings] ADD [InformationPreference] int NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [Settings] ADD [ProgressPreference] int NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [Settings] ADD [VerbosePreference] int NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [Settings] ADD [WarningPreference] int NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [Scripts] ADD [Icon] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [Permissions] ADD [Role] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    DECLARE @var40 sysname;
    SELECT @var40 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Job]') AND [c].[name] = N'ReadPermission');
    IF @var40 IS NOT NULL EXEC(N'ALTER TABLE [Job] DROP CONSTRAINT [' + @var40 + '];');
    ALTER TABLE [Job] ALTER COLUMN [ReadPermission] nvarchar(450) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [Identity] ADD [ExcludedScripts] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [Identity] ADD [SelectedScripts] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [EventHubConnections] ADD [Version] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [Branding] ADD [LoginPageCssStylesheet] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [Branding] ADD [LoginPageLayout] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [AuthenticationMethods] ADD [Domain] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [AuthenticationMethods] ADD [Native] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    ALTER TABLE [Apps] ADD [Critical] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    CREATE TABLE [ScheduleKeys] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NULL,
        [HangfireId] nvarchar(max) NULL,
        CONSTRAINT [PK_ScheduleKeys] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    CREATE INDEX [IX_Job_ReadPermission] ON [Job] ([ReadPermission]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250408215423_5.5.0'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20250408215423_5.5.0', N'9.0.3');
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Settings] ADD [DisableDatabaseVault] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Settings] ADD [PasswordExpirationDays] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Settings] ADD [PasswordLength] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Scripts] ADD [DisplayOutputOnExecute] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Scripts] ADD [PortalBehavior] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Scripts] ADD [PortalLeaveForm] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Schedules] ADD [ComputerGroup] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Schedules] ADD [ComputerGroupInvocationType] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Schedules] ADD [Folder] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [JobQueues] ADD [ComputerGroup] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    DECLARE @var41 sysname;
    SELECT @var41 = [d].[name]
    FROM [sys].[default_constraints] [d]
    INNER JOIN [sys].[columns] [c] ON [d].[parent_column_id] = [c].[column_id] AND [d].[parent_object_id] = [c].[object_id]
    WHERE ([d].[parent_object_id] = OBJECT_ID(N'[Job]') AND [c].[name] = N'ComputerName');
    IF @var41 IS NOT NULL EXEC(N'ALTER TABLE [Job] DROP CONSTRAINT [' + @var41 + '];');
    ALTER TABLE [Job] ALTER COLUMN [ComputerName] nvarchar(450) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Job] ADD [ComputerGroup] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Job] ADD [ComputerGroupInvocationType] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [GitSettings] ADD [GitSshKey] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Folders] ADD [Module] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [EventHubConnections] ADD [Description] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [EventHubConnections] ADD [RemoteIpv6Address] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [DashboardPage] ADD [AutoInclude] bit NOT NULL DEFAULT CAST(0 AS bit);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Computer] ADD [EditMode] int NOT NULL DEFAULT 0;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Computer] ADD [GitSshKey] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [ChildRunspaces] ADD [Name] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Branding] ADD [LoginPageBackgroundColor] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Branding] ADD [LoginPageFontColor] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    ALTER TABLE [Branding] ADD [LoginPageLogoSize] nvarchar(max) NULL;
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    CREATE TABLE [SshKeys] (
        [Id] bigint NOT NULL IDENTITY,
        [Name] nvarchar(max) NOT NULL,
        [PublicKey] nvarchar(max) NULL,
        [PrivateKey] nvarchar(max) NULL,
        [Timestamp] datetime2 NOT NULL,
        CONSTRAINT [PK_SshKeys] PRIMARY KEY ([Id])
    );
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    CREATE INDEX [IX_Job_ComputerName] ON [Job] ([ComputerName]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    CREATE INDEX [IX_Job_Status] ON [Job] ([Status]);
END;

IF NOT EXISTS (
    SELECT * FROM [__EFMigrationsHistory]
    WHERE [MigrationId] = N'20250702150417_5.6.0'
)
BEGIN
    INSERT INTO [__EFMigrationsHistory] ([MigrationId], [ProductVersion])
    VALUES (N'20250702150417_5.6.0', N'9.0.3');
END;

COMMIT;
GO

