New-UDPage -Name "Page" -Icon (New-UDIcon -Icon 'Page') -Content {
    New-UDTypography -Variant h3 -Text "Page"
    New-UDTypography -Variant subtitle1 -Text "Apps can be broken up into pages. Each page can have its own layout and content."

    New-UDDivider -Children {
        New-UDTypography -Variant h4 -Text 'Examples'
    }

    New-UDTypography -Variant h5 -Text "Name and Icon"
    New-UDTypography -Variant subtitle1 -Text "Each page can have a name and icon. The name is used in the navigation menu and the icon is used in the navigation menu and the page header."

    New-UDSyntaxHighlighter -Code @'
New-UDPage -Name "Page" -Icon (New-UDIcon -Icon 'Page') -Content {
}
'@ -Style 'oneDark' -ShowLineNumbers

    New-UDTypography -Variant h5 -Text "URL"
    New-UDTypography -Variant subtitle1 -Text "Pages can have URLs that do not have to match the name."

    New-UDSyntaxHighlighter -Code @'
New-UDPage -Name "Page" -Icon (New-UDIcon -Icon 'Page') -Url '/my-page' -Content {
}
'@ -Style 'oneDark' -ShowLineNumbers

    New-UDTypography -Variant h5 -Text "Variable Routes"
    New-UDTypography -Variant subtitle1 -Text "Page URLs can be variable routes. This allows you to pass parameters to the page."

    New-UDSyntaxHighlighter -Code @'
New-UDPage -Name "Page" -Icon (New-UDIcon -Icon 'Page') -Url '/my-page/:route' -Content {
    New-UDTypography -Text "Route: $Route"
}
'@ -Style 'oneDark' -ShowLineNumbers


    New-UDTypography -Variant h5 -Text "Custom Header"
    New-UDTypography -Variant subtitle1 -Text "Pages can have custom headers. This allows you to add custom content to the page header."

    New-UDSyntaxHighlighter -Code @'
New-UDPage -HeaderPosition fixed -Content {
    New-UDButton -Text "Click Me"
}
'@

    New-UDTypography -Variant h5 -Text "Navigation"
    New-UDTypography -Variant subtitle1 -Text "Pages can have custom navigation that does not match the app navigation."

    New-UDSyntaxHighlighter -Code @'
$Navigation = @(
    New-UDListItem -Label "Home"
    New-UDListItem -Label "Getting Started" -Children {
        New-UDListItem -Label "Installation" -Href '/Installation' 
        New-UDListItem -Label "Usage" -Href '/Usage' 
        New-UDListItem -Label "FAQs" -Href '/faqs' 
        New-UDListItem -Label "System Requirements" -Href'/requirements' 
        New-UDListItem -Label "Purchasing" -Href '/purchasing' 
    }
)

$Pages = @()
$Pages += New-UDPage -Name 'Installation' -Content {
    New-UDTypography -Text "Installation"
} -Navigation $Navigation
'@
}