New-UDPage -Name 'Variables' -Icon (New-UDIcon -Icon 'SquareRootVariable') -Content {
    $Variables = Get-Variable | ForEach-Object {
        [PSCustomObject]@{
            Name        = $_.Name
            Value       = if ($_.Value -eq $null) { "$null" } else { $_.Value.ToString() }
            Description = $_.Description
        }
    }
    New-UDTable -Title 'Variables' -Data $Variables -Columns @(
        New-UDTableColumn -Property Name -Title 'Name'
        New-UDTableColumn -Property Value -Title 'Value'
        New-UDTableColumn -Property Description -Title 'Description'
    ) -ShowPagination -Dense -PageSize 10
}