$HostFolder = Join-Path (Join-Path $PSScriptRoot "Hosts") "netstandard2.0"
$NestedHost = Join-Path $HostFolder "host.dll"
$LocalHost = Join-Path $PSScriptRoot "host.dll"

if (Test-Path $NestedHost) {
    Import-Module $NestedHost
}
else {
    Import-Module $LocalHost
} 

function Start-PSUHost {
    param(
        [int]$Port, 
        [long]$Id, 
        [int]$UniversalPort, 
        [int]$ParentProcessId,
        [Switch]$Debug,
        [string]$Environment,
        [UniversalAutomation.ProcessType]$Type
    )
    
    $Logger = [host.ConsoleLogger]::new()

    switch ($Type) {
        ([UniversalAutomation.ProcessType]::Api) {
            [UniversalHost.AgentService]::StartApi($Port, $ParentProcessId, $UniversalPort, $Logger)
        }
        ([UniversalAutomation.ProcessType]::Job) {
            [UniversalHost.AgentService]::StartJob($Port, $ParentProcessId, $UniversalPort, $Logger)
        }
        ([UniversalAutomation.ProcessType]::Dashboard) {
            [UniversalHost.AgentService]::StartDashboard($Port, $ParentProcessId, $UniversalPort, $Logger)
        }
        ([UniversalAutomation.ProcessType]::Security) {
            [UniversalHost.AgentService]::StartSecurity($Port, $ParentProcessId, $UniversalPort, $Logger)
        }
        ([UniversalAutomation.ProcessType]::ModuleDiscovery) {
            [UniversalHost.AgentService]::StartModuleDiscovery($Environment, $UniversalPort, $Logger)
        }
        ([UniversalAutomation.ProcessType]::Terminal) {
            [UniversalHost.AgentService]::StartTerminal($Id, $ParentProcessId, $UniversalPort, $Logger)
        }
    }


}