New-UDPage -Name 'Data Grid' -Icon (New-UDIcon -Icon 'TableCells') -Content {
    New-UDComponentDemo -Title 'Data Grid' -Icon 'TableCells' -Description 'Data tables display information in a grid-like format of rows and columns. They organize information in a way that''s easy to scan so that users can look for patterns and insights.' -Command 'New-UDDataGrud' -Content {
        $Data = 1..10000 | ForEach-Object {
            @{ Name = 'Adam'; Number = Get-Random }
        } 
        New-UDDataGrid -LoadRows {  
            function Out-UDDataGridData {
                param(
                    [Parameter(Mandatory)]
                    $Context,
                    [Parameter(Mandatory, ValueFromPipeline)]
                    [object]$Data,
                    [Parameter()]
                    [int]$TotalRows = -1
                )
                Begin {
                    $Items = [System.Collections.ArrayList]::new()
                }
                Process {
                    $Items.Add($Data) | Out-Null
                }

                End {
                    if ($null -ne $Context.Filter.Items -and $Context.Filter.Items.Count -gt 0) {
                        $linkOperator = $Context.Filter.linkOperator
                        $filterTextArray = @()
                        foreach ($filter in $Context.Filter.Items) {
                            $property = $Filter.columnField
                            $val = $filter.Value
                            switch ($filter.operatorValue) {
                                "contains" { $filterTextArray += "obj.$property -like ""*$val*""" }
                                "equals" { $filterTextArray += "obj.$property -eq ""*$val*""" }
                                "startsWith" { $filterTextArray += "obj.$property -like ""$val*""" }
                                "endsWith" { $filterTextArray += "obj.$property -like ""*$val""" }
                                "isAnyOf" { $filterTextArray += "obj.$property -in ""$val""" }
                                "notequals" { $filterTextArray += "obj.$property -ne ""$val""" }
                                "notcontains" { $filterTextArray += "obj.$property -notlike ""*$val*""" }
                                "isEmpty" { $filterTextArray += "obj.$property -eq null" }
                                "isNotEmpty" { $filterTextArray += "obj.$property -ne null" }
                            }
                        }
                        if ($linkOperator -eq 'and') {
                            [string]$filterTextLine = $filterTextArray -join " -and "
                        }
                        else {
                            [string]$filterTextLine = $filterTextArray -join " -or "
                        }

                        $filterTextLine = $filterTextLine.Replace('obj', '$_')
                        $filterTextLine = $filterTextLine.Replace('null', '$null')
                        $filterScriptBlock = [Scriptblock]::Create($filterTextLine)
                        $Items = $Items | Where-Object -FilterScript $filterScriptBlock
                    }

                    if ($null -ne $Items) {
                        $TotalRows = $Items.Count
                    }
                    else {
                        $TotalRows = 0
                    }

                    $Sort = $Context.Sort[0]
                    $Items = $Items | Sort-Object -Property $Sort.field -Descending:$($Sort.Sort -eq 'desc')
                    $Items = $Items | Select-Object -Skip ($Context.Page * $Context.pageSize) -First $Context.PageSize

                    @{
                        rows     = [Array]$Items
                        rowCount = $TotalRows
                    }
                }   
            }


            $Data | Out-UDDataGridData -Context $EventData
        } -Columns @(
            @{ field = "name"; render = { 
                    New-UDButton -Icon (New-UDIcon -Icon User) -OnClick { Show-UDToast $EventData.Name } } 
            }
            @{ field = "number" }
        ) -AutoHeight -Pagination 
    }
} -Static